/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.functions.CompileTimeFunction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class Unordered
extends CompileTimeFunction {
    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression = super.typeCheck(staticContext, itemType);
        if (expression instanceof Unordered) {
            Optimizer optimizer = staticContext.getConfiguration().getOptimizer();
            return ExpressionTool.unsorted(optimizer, ((Unordered)expression).argument[0], true);
        }
        return expression;
    }

    public Expression optimizer(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression = super.optimize(optimizer, staticContext, itemType);
        if (expression instanceof Unordered) {
            return ExpressionTool.unsorted(optimizer, ((Unordered)expression).argument[0], true);
        }
        return expression;
    }

    public Expression preEvaluate(StaticContext staticContext) throws XPathException {
        return this.argument[0];
    }
}

