/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.charcode;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import net.sf.saxon.charcode.CharacterSet;
import net.sf.saxon.om.XMLChar;

public class UnknownCharacterSet
implements CharacterSet {
    public static HashMap map;
    private CharsetEncoder encoder;
    private byte[] charinfo = new byte[65536];
    private StringBuffer supplementary = new StringBuffer(2);
    private static final byte GOOD = 1;
    private static final byte BAD = 2;

    private UnknownCharacterSet(Charset charset) {
        this.encoder = charset.newEncoder();
    }

    public static synchronized UnknownCharacterSet makeCharSet(Charset charset) {
        UnknownCharacterSet unknownCharacterSet;
        if (map == null) {
            map = new HashMap(10);
        }
        if ((unknownCharacterSet = (UnknownCharacterSet)map.get(charset)) == null) {
            unknownCharacterSet = new UnknownCharacterSet(charset);
            map.put(charset, unknownCharacterSet);
        }
        return unknownCharacterSet;
    }

    public final boolean inCharset(int n) {
        if (n <= 127) {
            return true;
        }
        if (n <= 65535) {
            if (this.charinfo[n] == 1) {
                return true;
            }
            if (this.charinfo[n] == 2) {
                return false;
            }
            if (this.encoder.canEncode((char)n)) {
                this.charinfo[n] = 1;
                return true;
            }
            this.charinfo[n] = 2;
            return false;
        }
        this.supplementary.setCharAt(0, XMLChar.highSurrogate(n));
        this.supplementary.setCharAt(1, XMLChar.lowSurrogate(n));
        return this.encoder.canEncode(this.supplementary);
    }
}

