/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CleanerTransformations;
import org.htmlcleaner.ContentToken;
import org.htmlcleaner.DefaultTagProvider;
import org.htmlcleaner.EndTagToken;
import org.htmlcleaner.HtmlCleanerException;
import org.htmlcleaner.HtmlTokenizer;
import org.htmlcleaner.ITagInfoProvider;
import org.htmlcleaner.SimpleXmlSerializer;
import org.htmlcleaner.TagInfo;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;

public class HtmlCleaner {
    public static final String DEFAULT_CHARSET = System.getProperty("file.encoding");
    private CleanerProperties properties;
    private ITagInfoProvider tagInfoProvider;
    private CleanerTransformations transformations = null;
    private transient OpenTags _openTags;
    private transient boolean _headOpened = false;
    private transient boolean _bodyOpened = false;
    private transient Set _headTags = new LinkedHashSet();
    private Set allTags = new TreeSet();
    private TagNode htmlNode;
    private TagNode bodyNode;
    private TagNode headNode;
    private TagNode rootNode;
    private Set pruneTagSet = new HashSet();
    private Set pruneNodeSet = new HashSet();

    public HtmlCleaner() {
        this(null, null);
    }

    public HtmlCleaner(ITagInfoProvider tagInfoProvider) {
        this(tagInfoProvider, null);
    }

    public HtmlCleaner(CleanerProperties properties) {
        this(null, properties);
    }

    public HtmlCleaner(ITagInfoProvider tagInfoProvider, CleanerProperties properties) {
        this.tagInfoProvider = tagInfoProvider == null ? DefaultTagProvider.getInstance() : tagInfoProvider;
        this.properties = properties == null ? new CleanerProperties() : properties;
        this.properties.tagInfoProvider = this.tagInfoProvider;
    }

    public TagNode clean(String htmlContent) throws IOException {
        return this.clean(new StringReader(htmlContent));
    }

    public TagNode clean(File file, String charset) throws IOException {
        FileInputStream in = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader((InputStream)in, charset);
        return this.clean(reader);
    }

    public TagNode clean(File file) throws IOException {
        return this.clean(file, DEFAULT_CHARSET);
    }

    public TagNode clean(URL url, String charset) throws IOException {
        StringBuffer content = Utils.readUrl(url, charset);
        StringReader reader = new StringReader(content.toString());
        return this.clean(reader);
    }

    public TagNode clean(URL url) throws IOException {
        return this.clean(url, DEFAULT_CHARSET);
    }

    public TagNode clean(InputStream in, String charset) throws IOException {
        return this.clean(new InputStreamReader(in, charset));
    }

    public TagNode clean(InputStream in) throws IOException {
        return this.clean(in, DEFAULT_CHARSET);
    }

    public TagNode clean(Reader reader) throws IOException {
        this._openTags = new OpenTags();
        this._headOpened = false;
        this._bodyOpened = false;
        this._headTags.clear();
        this.allTags.clear();
        this.setPruneTags(this.properties.pruneTags);
        this.htmlNode = new TagNode("html", this);
        this.bodyNode = new TagNode("body", this);
        this.headNode = new TagNode("head", this);
        this.rootNode = null;
        this.htmlNode.addChild(this.headNode);
        this.htmlNode.addChild(this.bodyNode);
        HtmlTokenizer htmlTokenizer = new HtmlTokenizer(this, reader);
        htmlTokenizer.start();
        List nodeList = htmlTokenizer.getTokenList();
        this.closeAll(nodeList);
        this.createDocumentNodes(nodeList);
        this.calculateRootNode(htmlTokenizer.getNamespacePrefixes());
        if (this.pruneNodeSet != null && !this.pruneNodeSet.isEmpty()) {
            Iterator iterator = this.pruneNodeSet.iterator();
            while (iterator.hasNext()) {
                TagNode tagNode = (TagNode)iterator.next();
                TagNode parent = tagNode.getParent();
                if (parent == null) continue;
                parent.removeChild(tagNode);
            }
        }
        this.rootNode.setDocType(htmlTokenizer.getDocType());
        return this.rootNode;
    }

    private void calculateRootNode(Set namespacePrefixes) {
        Iterator iterator;
        List bodyChildren;
        this.rootNode = this.htmlNode;
        if (this.properties.omitHtmlEnvelope && (bodyChildren = this.bodyNode.getChildren()) != null) {
            iterator = bodyChildren.iterator();
            while (iterator.hasNext()) {
                Object currChild = iterator.next();
                if (!(currChild instanceof TagNode)) continue;
                this.rootNode = (TagNode)currChild;
            }
        }
        Map atts = this.rootNode.getAttributes();
        if (this.properties.namespacesAware && namespacePrefixes != null) {
            iterator = namespacePrefixes.iterator();
            while (iterator.hasNext()) {
                String prefix = (String)iterator.next();
                String xmlnsAtt = "xmlns:" + prefix;
                if (atts.containsKey(xmlnsAtt)) continue;
                this.rootNode.addAttribute(xmlnsAtt, prefix);
            }
        }
    }

    private void addAttributesToTag(TagNode tag, Map attributes) {
        if (attributes != null) {
            Map tagAttributes = tag.getAttributes();
            Iterator it = attributes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry currEntry = it.next();
                String attName = (String)currEntry.getKey();
                if (tagAttributes.containsKey(attName)) continue;
                String attValue = (String)currEntry.getValue();
                tag.addAttribute(attName, attValue);
            }
        }
    }

    private boolean isFatalTagSatisfied(TagInfo tag) {
        if (tag != null) {
            String fatalTagName = tag.getFatalTag();
            return fatalTagName == null ? true : this._openTags.tagExists(fatalTagName);
        }
        return true;
    }

    private boolean mustAddRequiredParent(TagInfo tag) {
        String requiredParent;
        if (tag != null && (requiredParent = tag.getRequiredParent()) != null) {
            TagPos tagPos;
            String fatalTag = tag.getFatalTag();
            int fatalTagPositon = -1;
            if (fatalTag != null && (tagPos = this._openTags.findTag(fatalTag)) != null) {
                fatalTagPositon = tagPos.position;
            }
            ListIterator it = this._openTags.list.listIterator(this._openTags.list.size());
            while (it.hasPrevious()) {
                TagPos currTagPos = (TagPos)it.previous();
                if (!tag.isHigher(currTagPos.name)) continue;
                return currTagPos.position <= fatalTagPositon;
            }
            return true;
        }
        return false;
    }

    private TagNode createTagNode(TagNode startTagToken) {
        startTagToken.setFormed();
        return startTagToken;
    }

    private boolean isAllowedInLastOpenTag(BaseToken token) {
        TagPos last = this._openTags.getLastTagPos();
        if (last != null && last.info != null) {
            return last.info.allowsItem(token);
        }
        return true;
    }

    private void saveToLastOpenTag(List nodeList, Object tokenToAdd) {
        TagPos last = this._openTags.getLastTagPos();
        if (last != null && last.info != null && last.info.isIgnorePermitted()) {
            return;
        }
        TagPos rubbishPos = this._openTags.findTagToPlaceRubbish();
        if (rubbishPos != null) {
            TagNode startTagToken = (TagNode)nodeList.get(rubbishPos.position);
            startTagToken.addItemForMoving(tokenToAdd);
        }
    }

    private boolean isStartToken(Object o) {
        return o instanceof TagNode && !((TagNode)o).isFormed();
    }

    void makeTree(List nodeList, ListIterator nodeIterator) {
        while (nodeIterator.hasNext()) {
            TagInfo tag;
            String tagName;
            BaseToken token = (BaseToken)nodeIterator.next();
            if (token instanceof EndTagToken) {
                EndTagToken endTagToken = (EndTagToken)token;
                tagName = endTagToken.getName();
                tag = this.tagInfoProvider.getTagInfo(tagName);
                if (tag == null && this.properties.omitUnknownTags || tag != null && tag.isDeprecated() && this.properties.omitDeprecatedTags) {
                    nodeIterator.set(null);
                    continue;
                }
                if (tag != null && !tag.allowsBody()) {
                    nodeIterator.set(null);
                    continue;
                }
                TagPos matchingPosition = this._openTags.findTag(tagName);
                if (matchingPosition != null) {
                    List closed = this.closeSnippet(nodeList, matchingPosition, endTagToken);
                    nodeIterator.set(null);
                    for (int i = closed.size() - 1; i >= 1; --i) {
                        TagNode closedTag = (TagNode)closed.get(i);
                        if (tag == null || !tag.isContinueAfter(closedTag.getName())) continue;
                        nodeIterator.add(closedTag.makeCopy());
                        nodeIterator.previous();
                    }
                    continue;
                }
                if (this.isAllowedInLastOpenTag(token)) continue;
                this.saveToLastOpenTag(nodeList, token);
                nodeIterator.set(null);
                continue;
            }
            if (this.isStartToken(token)) {
                TagNode startTagToken = (TagNode)token;
                tagName = startTagToken.getName();
                tag = this.tagInfoProvider.getTagInfo(tagName);
                TagPos lastTagPos = this._openTags.isEmpty() ? null : this._openTags.getLastTagPos();
                TagInfo lastTagInfo = lastTagPos == null ? null : this.tagInfoProvider.getTagInfo(lastTagPos.name);
                this.allTags.add(tagName);
                if ("html".equals(tagName)) {
                    this.addAttributesToTag(this.htmlNode, startTagToken.getAttributes());
                    nodeIterator.set(null);
                    continue;
                }
                if ("body".equals(tagName)) {
                    this._bodyOpened = true;
                    this.addAttributesToTag(this.bodyNode, startTagToken.getAttributes());
                    nodeIterator.set(null);
                    continue;
                }
                if ("head".equals(tagName)) {
                    this._headOpened = true;
                    this.addAttributesToTag(this.headNode, startTagToken.getAttributes());
                    nodeIterator.set(null);
                    continue;
                }
                if (tag == null && this.properties.omitUnknownTags || tag != null && tag.isDeprecated() && this.properties.omitDeprecatedTags) {
                    nodeIterator.set(null);
                    continue;
                }
                if (tag == null && lastTagInfo != null && !lastTagInfo.allowsAnything()) {
                    this.closeSnippet(nodeList, lastTagPos, startTagToken);
                    nodeIterator.previous();
                    continue;
                }
                if (tag != null && tag.hasPermittedTags() && this._openTags.someAlreadyOpen(tag.getPermittedTags())) {
                    nodeIterator.set(null);
                    continue;
                }
                if (tag != null && tag.isUnique() && this._openTags.tagEncountered(tagName)) {
                    nodeIterator.set(null);
                    continue;
                }
                if (!this.isFatalTagSatisfied(tag)) {
                    nodeIterator.set(null);
                    continue;
                }
                if (this.mustAddRequiredParent(tag)) {
                    String requiredParent = tag.getRequiredParent();
                    TagNode requiredParentStartToken = new TagNode(requiredParent, this);
                    nodeIterator.previous();
                    nodeIterator.add(requiredParentStartToken);
                    nodeIterator.previous();
                    continue;
                }
                if (tag != null && lastTagPos != null && tag.isMustCloseTag(lastTagInfo)) {
                    List closed = this.closeSnippet(nodeList, lastTagPos, startTagToken);
                    int closedCount = closed.size();
                    if (tag.hasCopyTags() && closedCount > 0) {
                        TagNode currStartToken;
                        ListIterator closedIt = closed.listIterator(closedCount);
                        ArrayList<TagNode> toBeCopied = new ArrayList<TagNode>();
                        while (closedIt.hasPrevious() && tag.isCopy((currStartToken = (TagNode)closedIt.previous()).getName())) {
                            toBeCopied.add(0, currStartToken);
                        }
                        if (toBeCopied.size() > 0) {
                            Iterator copyIt = toBeCopied.iterator();
                            while (copyIt.hasNext()) {
                                TagNode currStartToken2 = (TagNode)copyIt.next();
                                nodeIterator.add(currStartToken2.makeCopy());
                            }
                            for (int i = 0; i < toBeCopied.size(); ++i) {
                                nodeIterator.previous();
                            }
                        }
                    }
                    nodeIterator.previous();
                    continue;
                }
                if (!this.isAllowedInLastOpenTag(token)) {
                    this.saveToLastOpenTag(nodeList, token);
                    nodeIterator.set(null);
                    continue;
                }
                if (tag != null && !tag.allowsBody()) {
                    TagNode newTagNode = this.createTagNode(startTagToken);
                    this.addPossibleHeadCandidate(tag, newTagNode);
                    nodeIterator.set(newTagNode);
                    continue;
                }
                this._openTags.addTag(tagName, nodeIterator.previousIndex());
                continue;
            }
            if (this.isAllowedInLastOpenTag(token)) continue;
            this.saveToLastOpenTag(nodeList, token);
            nodeIterator.set(null);
        }
    }

    private void createDocumentNodes(List listNodes) {
        Iterator it = listNodes.iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (child == null) continue;
            boolean toAdd = true;
            if (child instanceof TagNode) {
                TagNode node = (TagNode)child;
                TagInfo tag = this.tagInfoProvider.getTagInfo(node.getName());
                this.addPossibleHeadCandidate(tag, node);
            } else if (child instanceof ContentToken) {
                boolean bl = toAdd = !"".equals(child.toString());
            }
            if (!toAdd) continue;
            this.bodyNode.addChild(child);
        }
        Iterator headIterator = this._headTags.iterator();
        while (headIterator.hasNext()) {
            TagNode headCandidateNode = (TagNode)headIterator.next();
            boolean toMove = true;
            for (TagNode parent = headCandidateNode.getParent(); parent != null; parent = parent.getParent()) {
                if (!this._headTags.contains(parent)) continue;
                toMove = false;
                break;
            }
            if (!toMove) continue;
            headCandidateNode.removeFromTree();
            this.headNode.addChild(headCandidateNode);
        }
    }

    private List closeSnippet(List nodeList, TagPos tagPos, Object toNode) {
        ArrayList<TagNode> closed = new ArrayList<TagNode>();
        ListIterator<Object> it = nodeList.listIterator(tagPos.position);
        TagNode tagNode = null;
        Object item = it.next();
        boolean isListEnd = false;
        while (toNode == null && !isListEnd || toNode != null && item != toNode) {
            if (this.isStartToken(item)) {
                TagNode startTagToken = (TagNode)item;
                closed.add(startTagToken);
                List itemsToMove = startTagToken.getItemsToMove();
                if (itemsToMove != null) {
                    OpenTags prevOpenTags = this._openTags;
                    this._openTags = new OpenTags();
                    this.makeTree(itemsToMove, itemsToMove.listIterator(0));
                    this.closeAll(itemsToMove);
                    startTagToken.setItemsToMove(null);
                    this._openTags = prevOpenTags;
                }
                TagNode newTagNode = this.createTagNode(startTagToken);
                TagInfo tag = this.tagInfoProvider.getTagInfo(newTagNode.getName());
                this.addPossibleHeadCandidate(tag, newTagNode);
                if (tagNode != null) {
                    tagNode.addChildren(itemsToMove);
                    tagNode.addChild(newTagNode);
                    it.set(null);
                } else if (itemsToMove != null) {
                    itemsToMove.add(newTagNode);
                    it.set(itemsToMove);
                } else {
                    it.set(newTagNode);
                }
                this._openTags.removeTag(newTagNode.getName());
                tagNode = newTagNode;
            } else if (tagNode != null) {
                it.set(null);
                if (item != null) {
                    tagNode.addChild(item);
                }
            }
            if (it.hasNext()) {
                item = it.next();
                continue;
            }
            isListEnd = true;
        }
        return closed;
    }

    private void closeAll(List nodeList) {
        TagPos firstTagPos = this._openTags.findFirstTagPos();
        if (firstTagPos != null) {
            this.closeSnippet(nodeList, firstTagPos, null);
        }
    }

    private void addPossibleHeadCandidate(TagInfo tagInfo, TagNode tagNode) {
        if (tagInfo != null && tagNode != null && (tagInfo.isHeadTag() || tagInfo.isHeadAndBodyTag() && this._headOpened && !this._bodyOpened)) {
            this._headTags.add(tagNode);
        }
    }

    public CleanerProperties getProperties() {
        return this.properties;
    }

    public Set getPruneTagSet() {
        return this.pruneTagSet;
    }

    private void setPruneTags(String pruneTags) {
        this.pruneTagSet.clear();
        this.pruneNodeSet.clear();
        if (pruneTags != null) {
            StringTokenizer tokenizer = new StringTokenizer(pruneTags, ",");
            while (tokenizer.hasMoreTokens()) {
                this.pruneTagSet.add(tokenizer.nextToken().trim().toLowerCase());
            }
        }
    }

    void addPruneNode(TagNode node) {
        this.pruneNodeSet.add(node);
    }

    public Set getAllTags() {
        return this.allTags;
    }

    public ITagInfoProvider getTagInfoProvider() {
        return this.tagInfoProvider;
    }

    public CleanerTransformations getTransformations() {
        return this.transformations;
    }

    public void setTransformations(CleanerTransformations transformations) {
        this.transformations = transformations;
    }

    public String getInnerHtml(TagNode node) {
        if (node != null) {
            try {
                String content = new SimpleXmlSerializer(this.properties).getXmlAsString(node);
                int index1 = content.indexOf("<" + node.getName());
                index1 = content.indexOf(62, index1 + 1);
                int index2 = content.lastIndexOf(60);
                return index1 >= 0 && index1 <= index2 ? content.substring(index1 + 1, index2) : null;
            }
            catch (IOException e) {
                throw new HtmlCleanerException(e);
            }
        }
        throw new HtmlCleanerException("Cannot return inner html of the null node!");
    }

    public void setInnerHtml(TagNode node, String content) {
        if (node != null) {
            String nodeName = node.getName();
            StringBuffer html = new StringBuffer();
            html.append("<" + nodeName + " marker=''>");
            html.append(content);
            html.append("</" + nodeName + ">");
            for (TagNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
                String parentName = parent.getName();
                html.insert(0, "<" + parentName + ">");
                html.append("</" + parentName + ">");
            }
            try {
                TagNode rootNode = this.clean(html.toString());
                TagNode cleanedNode = rootNode.findElementHavingAttribute("marker", true);
                if (cleanedNode != null) {
                    node.setChildren(cleanedNode.getChildren());
                }
            }
            catch (IOException e) {
                throw new HtmlCleanerException(e);
            }
        }
    }

    private class OpenTags {
        private List list = new ArrayList();
        private TagPos last = null;
        private Set set = new HashSet();

        private OpenTags() {
        }

        private boolean isEmpty() {
            return this.list.isEmpty();
        }

        private void addTag(String tagName, int position) {
            this.last = new TagPos(position, tagName);
            this.list.add(this.last);
            this.set.add(tagName);
        }

        private void removeTag(String tagName) {
            ListIterator it = this.list.listIterator(this.list.size());
            while (it.hasPrevious()) {
                TagPos currTagPos = (TagPos)it.previous();
                if (!tagName.equals(currTagPos.name)) continue;
                it.remove();
                break;
            }
            this.last = this.list.isEmpty() ? null : (TagPos)this.list.get(this.list.size() - 1);
        }

        private TagPos findFirstTagPos() {
            return this.list.isEmpty() ? null : (TagPos)this.list.get(0);
        }

        private TagPos getLastTagPos() {
            return this.last;
        }

        private TagPos findTag(String tagName) {
            if (tagName != null) {
                ListIterator it = this.list.listIterator(this.list.size());
                String fatalTag = null;
                TagInfo fatalInfo = HtmlCleaner.this.tagInfoProvider.getTagInfo(tagName);
                if (fatalInfo != null) {
                    fatalTag = fatalInfo.getFatalTag();
                }
                while (it.hasPrevious()) {
                    TagPos currTagPos = (TagPos)it.previous();
                    if (tagName.equals(currTagPos.name)) {
                        return currTagPos;
                    }
                    if (fatalTag == null || !fatalTag.equals(currTagPos.name)) continue;
                    return null;
                }
            }
            return null;
        }

        private boolean tagExists(String tagName) {
            TagPos tagPos = this.findTag(tagName);
            return tagPos != null;
        }

        private TagPos findTagToPlaceRubbish() {
            TagPos result = null;
            TagPos prev = null;
            if (!this.isEmpty()) {
                ListIterator it = this.list.listIterator(this.list.size());
                while (it.hasPrevious()) {
                    result = (TagPos)it.previous();
                    if ((result.info == null || result.info.allowsAnything()) && prev != null) {
                        return prev;
                    }
                    prev = result;
                }
            }
            return result;
        }

        private boolean tagEncountered(String tagName) {
            return this.set.contains(tagName);
        }

        private boolean someAlreadyOpen(Set tags) {
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                TagPos curr = (TagPos)it.next();
                if (!tags.contains(curr.name)) continue;
                return true;
            }
            return false;
        }
    }

    private class TagPos {
        private int position;
        private String name;
        private TagInfo info;

        TagPos(int position, String name) {
            this.position = position;
            this.name = name;
            this.info = HtmlCleaner.this.tagInfoProvider.getTagInfo(name);
        }
    }
}

