/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ListenerSet;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.JGroupsNotifierTransporter;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.UpdateResponse;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;
import org.nuiton.wikitty.WikittyTransaction;
import org.nuiton.wikitty.WikittyTree;
import org.nuiton.wikitty.WikittyTreeNode;

public class WikittyServiceNotifier
implements WikittyService {
    private static Log log = LogFactory.getLog(WikittyServiceNotifier.class);
    protected WikittyService ws;
    protected ListenerSet<WikittyServiceListener> allWikittyServiceListeners;
    protected ListenerSet<WikittyServiceListener> localWikittyServiceListeners;
    protected ListenerSet<WikittyServiceListener> remoteWikittyServiceListeners;
    protected WikittyServiceListener notifier;
    protected LinkedBlockingQueue<WikittyServiceEvent> eventToSend;
    protected EventThread eventThread;

    public WikittyServiceNotifier(WikittyService ws) {
        this(ws, null);
    }

    public WikittyServiceNotifier(WikittyService ws, Properties props) {
        this.ws = ws;
        this.allWikittyServiceListeners = new ListenerSet();
        this.localWikittyServiceListeners = new ListenerSet();
        this.remoteWikittyServiceListeners = new ListenerSet();
        this.eventToSend = new LinkedBlockingQueue();
        this.eventThread = new EventThread(this.eventToSend, this.allWikittyServiceListeners, this.localWikittyServiceListeners, this.remoteWikittyServiceListeners);
        if (props != null) {
            this.notifier = new RemoteNotifier(this, props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWikittyServiceListener(WikittyServiceListener listener, WikittyService.ServiceListenerType type) {
        switch (type) {
            case ALL: {
                ListenerSet<WikittyServiceListener> listenerSet = this.allWikittyServiceListeners;
                synchronized (listenerSet) {
                    this.allWikittyServiceListeners.add((Object)listener);
                    break;
                }
            }
            case LOCAL: {
                ListenerSet<WikittyServiceListener> listenerSet = this.localWikittyServiceListeners;
                synchronized (listenerSet) {
                    this.localWikittyServiceListeners.add((Object)listener);
                    break;
                }
            }
            case REMOTE: {
                ListenerSet<WikittyServiceListener> listenerSet = this.remoteWikittyServiceListeners;
                synchronized (listenerSet) {
                    this.remoteWikittyServiceListeners.add((Object)listener);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWikittyServiceListener(WikittyServiceListener listener, WikittyService.ServiceListenerType type) {
        switch (type) {
            case ALL: {
                ListenerSet<WikittyServiceListener> listenerSet = this.allWikittyServiceListeners;
                synchronized (listenerSet) {
                    this.allWikittyServiceListeners.remove((Object)listener);
                    break;
                }
            }
            case LOCAL: {
                ListenerSet<WikittyServiceListener> listenerSet = this.localWikittyServiceListeners;
                synchronized (listenerSet) {
                    this.localWikittyServiceListeners.remove((Object)listener);
                    break;
                }
            }
            case REMOTE: {
                ListenerSet<WikittyServiceListener> listenerSet = this.remoteWikittyServiceListeners;
                synchronized (listenerSet) {
                    this.remoteWikittyServiceListeners.remove((Object)listener);
                    break;
                }
            }
        }
    }

    @Override
    public String login(String login, String password) {
        return this.ws.login(login, password);
    }

    @Override
    public void logout(String securityToken) {
        this.ws.logout(securityToken);
    }

    @Override
    public boolean canWrite(String securityToken, Wikitty wikitty) {
        return this.ws.canWrite(securityToken, wikitty);
    }

    @Override
    public boolean canDelete(String securityToken, String wikittyId) {
        return this.ws.canDelete(securityToken, wikittyId);
    }

    @Override
    public boolean canRead(String securityToken, String wikittyId) {
        return this.ws.canRead(securityToken, wikittyId);
    }

    @Override
    public void clear(String securityToken) {
        this.ws.clear(securityToken);
    }

    @Override
    public UpdateResponse store(String securityToken, Wikitty wikitty) {
        UpdateResponse updateResponse = this.ws.store(securityToken, wikitty);
        updateResponse.update(wikitty);
        this.firePutWikitty(wikitty);
        return updateResponse;
    }

    @Override
    public UpdateResponse store(String securityToken, Collection<Wikitty> wikitties) {
        UpdateResponse updateResponse = this.ws.store(securityToken, wikitties);
        for (Wikitty wikitty : wikitties) {
            updateResponse.update(wikitty);
        }
        this.firePutWikitty(wikitties.toArray(new Wikitty[wikitties.size()]));
        return updateResponse;
    }

    @Override
    public UpdateResponse store(String securityToken, Collection<Wikitty> wikitties, boolean force) {
        UpdateResponse updateResponse = this.ws.store(securityToken, wikitties, force);
        for (Wikitty wikitty : wikitties) {
            updateResponse.update(wikitty);
        }
        this.firePutWikitty(wikitties.toArray(new Wikitty[wikitties.size()]));
        return updateResponse;
    }

    @Override
    public UpdateResponse store(String securityToken, WikittyTransaction transaction, Collection<Wikitty> wikitties, boolean force) {
        UpdateResponse updateResponse = this.ws.store(securityToken, transaction, wikitties, force);
        for (Wikitty wikitty : wikitties) {
            updateResponse.update(wikitty);
        }
        this.firePutWikitty(wikitties.toArray(new Wikitty[wikitties.size()]));
        return updateResponse;
    }

    @Override
    public List<String> getAllExtensionIds(String securityToken) {
        return this.ws.getAllExtensionIds(securityToken);
    }

    @Override
    public List<String> getAllExtensionsRequires(String securityToken, String extensionName) {
        return this.ws.getAllExtensionsRequires(securityToken, extensionName);
    }

    @Override
    public UpdateResponse storeExtension(String securityToken, WikittyExtension ext) {
        UpdateResponse updateResponse = this.ws.storeExtension(securityToken, ext);
        this.firePutExtension(ext);
        return updateResponse;
    }

    @Override
    public UpdateResponse storeExtension(String securityToken, Collection<WikittyExtension> exts) {
        UpdateResponse updateResponse = this.ws.storeExtension(securityToken, exts);
        this.firePutExtension(exts.toArray(new WikittyExtension[exts.size()]));
        return updateResponse;
    }

    @Override
    public UpdateResponse storeExtension(String securityToken, WikittyTransaction transaction, Collection<WikittyExtension> exts) {
        UpdateResponse updateResponse = this.ws.storeExtension(securityToken, transaction, exts);
        return updateResponse;
    }

    @Override
    public WikittyExtension restoreExtension(String securityToken, String id) {
        return this.ws.restoreExtension(securityToken, id);
    }

    @Override
    public WikittyExtension restoreExtension(String securityToken, WikittyTransaction transaction, String id) {
        return this.ws.restoreExtension(securityToken, transaction, id);
    }

    @Override
    public WikittyExtension restoreExtensionLastVersion(String securityToken, String name) {
        return this.ws.restoreExtensionLastVersion(securityToken, name);
    }

    @Override
    public WikittyExtension restoreExtensionLastVersion(String securityToken, WikittyTransaction transaction, String name) {
        return this.ws.restoreExtensionLastVersion(securityToken, transaction, name);
    }

    @Override
    public Wikitty restore(String securityToken, String id) {
        return this.ws.restore(securityToken, id);
    }

    @Override
    public List<Wikitty> restore(String securityToken, List<String> ids) {
        return this.ws.restore(securityToken, ids);
    }

    @Override
    public List<Wikitty> restore(String securityToken, WikittyTransaction transaction, List<String> ids) {
        return this.ws.restore(securityToken, transaction, ids);
    }

    @Override
    public void delete(String securityToken, String id) {
        this.ws.delete(securityToken, id);
        this.fireRemoveWikitty(id);
    }

    @Override
    public void delete(String securityToken, Collection<String> ids) {
        this.ws.delete(securityToken, ids);
        this.fireRemoveWikitty(ids.toArray(new String[ids.size()]));
    }

    @Override
    public PagedResult<String> findAllByCriteria(String securityToken, Criteria criteria) {
        return this.ws.findAllByCriteria(securityToken, criteria);
    }

    @Override
    public PagedResult<String> findAllByCriteria(String securityToken, WikittyTransaction transaction, Criteria criteria) {
        return this.ws.findAllByCriteria(securityToken, transaction, criteria);
    }

    @Override
    public Wikitty findByCriteria(String securityToken, Criteria criteria) {
        return this.ws.findByCriteria(securityToken, criteria);
    }

    @Override
    public Wikitty findByCriteria(String securityToken, WikittyTransaction transaction, Criteria criteria) {
        return this.ws.findByCriteria(securityToken, transaction, criteria);
    }

    @Override
    public WikittyTree restoreTree(String securityToken, String wikittyId) {
        return this.ws.restoreTree(securityToken, wikittyId);
    }

    @Override
    public List<String> deleteTree(String securityToken, String wikittyId) {
        List<String> result = this.ws.deleteTree(securityToken, wikittyId);
        this.fireRemoveWikitty(result.toArray(new String[result.size()]));
        return result;
    }

    @Override
    public Map.Entry<WikittyTreeNode, Integer> restoreNode(String securityToken, String wikittyId, Criteria filter) {
        return this.ws.restoreNode(securityToken, wikittyId, filter);
    }

    @Override
    public Map<WikittyTreeNode, Integer> restoreChildren(String securityToken, String wikittyId, Criteria filter) {
        return this.ws.restoreChildren(securityToken, wikittyId, filter);
    }

    @Override
    public Wikitty restoreVersion(String securityToken, String wikittyId, String version) {
        return this.ws.restoreVersion(securityToken, wikittyId, version);
    }

    @Override
    public UpdateResponse syncEngin(String securityToken) {
        return this.ws.syncEngin(securityToken);
    }

    protected void firePutWikitty(Wikitty ... ws) {
        WikittyServiceEvent event = new WikittyServiceEvent(ws, WikittyServiceEvent.WikittyEventType.PUT_WIKITTY);
        HashSet<String> ids = new HashSet<String>();
        HashMap<String, Set<String>> idsExtension = new HashMap<String, Set<String>>();
        HashMap<String, String> idsVersion = new HashMap<String, String>();
        for (Wikitty w : ws) {
            ids.add(w.getId());
            HashSet<String> extension = new HashSet<String>();
            extension.addAll(w.getExtensionNames());
            idsExtension.put(w.getId(), extension);
            idsVersion.put(w.getId(), w.getVersion());
        }
        event.setIds(ids);
        event.setIdExtensions(idsExtension);
        event.setIdVersions(idsVersion);
        this.fireEvent(event);
    }

    protected void fireRemoveWikitty(String ... wikittyIds) {
        WikittyServiceEvent event = new WikittyServiceEvent(this.ws, WikittyServiceEvent.WikittyEventType.REMOVE_WIKITTY);
        HashSet<String> ids = new HashSet<String>();
        for (String wikittyId : wikittyIds) {
            ids.add(wikittyId);
        }
        event.setIds(ids);
        this.fireEvent(event);
    }

    protected void fireClearWikitty() {
        WikittyServiceEvent event = new WikittyServiceEvent(this.ws, WikittyServiceEvent.WikittyEventType.CLEAR_WIKITTY);
        this.fireEvent(event);
    }

    protected void firePutExtension(WikittyExtension ... exts) {
        WikittyServiceEvent event = new WikittyServiceEvent(this.ws, WikittyServiceEvent.WikittyEventType.PUT_EXTENSION);
        HashSet<String> ids = new HashSet<String>();
        HashMap<String, Set<String>> idsExtension = new HashMap<String, Set<String>>();
        for (WikittyExtension ext : exts) {
            ids.add(ext.getId());
            HashSet<String> extension = new HashSet<String>();
            extension.add(ext.getName());
            extension.add(ext.requires);
            idsExtension.put(ext.getId(), extension);
        }
        event.setIds(ids);
        event.setIdExtensions(idsExtension);
        this.fireEvent(event);
    }

    protected void fireRemoveExtension(WikittyExtension ... exts) {
        WikittyServiceEvent event = new WikittyServiceEvent(this.ws, WikittyServiceEvent.WikittyEventType.REMOVE_EXTENSION);
        HashSet<String> ids = new HashSet<String>();
        for (WikittyExtension ext : exts) {
            ids.add(ext.getId());
        }
        event.setIds(ids);
        this.fireEvent(event);
    }

    protected void fireClearExtension() {
        WikittyServiceEvent event = new WikittyServiceEvent(this.ws, WikittyServiceEvent.WikittyEventType.CLEAR_EXTENSION);
        this.fireEvent(event);
    }

    protected void fireEvent(WikittyServiceEvent event) {
        EventThread thread = this.getEventThread();
        if (thread.stopAsked()) {
            throw new WikittyException("Event thread dispatcher is stopped, no more event can be send");
        }
        this.eventToSend.offer(event);
        if (!thread.isAlive()) {
            thread.start();
        }
    }

    public void processRemoteEvent(WikittyServiceEvent event) {
        event.setSource(this);
        event.setRemote(true);
        this.fireEvent(event);
    }

    public EventThread getEventThread() {
        return this.eventThread;
    }

    protected void finalize() throws Throwable {
        this.getEventThread().askStop();
        super.finalize();
    }

    public static class RemoteNotifier
    implements WikittyServiceListener {
        private static Log log = LogFactory.getLog(RemoteNotifier.class);
        public static final String WIKITTY_EVENT_PROPAGATE_OPTION = "wikitty.service.event.propagateEvent";
        public static final String WIKITTY_NOTIFIER_TRANSPORTER_CLASS = "wikitty.notifier.transporter.class";
        protected WikittyServiceNotifier ws;
        protected boolean propagateEvent = false;
        protected RemoteNotifierTransporter transporter;

        public RemoteNotifier(WikittyServiceNotifier ws, Properties props) {
            if (props != null) {
                this.ws = ws;
                if (!props.containsKey(WIKITTY_NOTIFIER_TRANSPORTER_CLASS)) {
                    props.setProperty(WIKITTY_NOTIFIER_TRANSPORTER_CLASS, JGroupsNotifierTransporter.class.getName());
                }
                ApplicationConfig config = new ApplicationConfig(props);
                this.propagateEvent = config.getOptionAsBoolean(WIKITTY_EVENT_PROPAGATE_OPTION);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Set propagateEvent option to " + this.propagateEvent));
                }
                Class transporterClass = config.getOptionAsClass(WIKITTY_NOTIFIER_TRANSPORTER_CLASS);
                try {
                    this.transporter = (RemoteNotifierTransporter)ConstructorUtils.invokeConstructor((Class)transporterClass, (Object[])new Object[]{ws, props}, (Class[])new Class[]{WikittyServiceNotifier.class, Properties.class});
                }
                catch (Exception eee) {
                    throw new WikittyException("Can't create notifier: " + transporterClass.getName(), eee);
                }
                ws.addWikittyServiceListener(this, WikittyService.ServiceListenerType.ALL);
            }
            if (log.isInfoEnabled()) {
                if (this.transporter == null) {
                    log.info((Object)"RemoteNotifier synchronisation not used ");
                } else {
                    log.info((Object)("RemoteNotifier transporter: " + this.transporter.getClass().getName()));
                }
            }
        }

        protected void sendMessage(WikittyServiceEvent event) {
            block4: {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Try to send message : " + event));
                    }
                    this.transporter.sendMessage(event);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Message is sent : " + event));
                    }
                }
                catch (Exception eee) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Can't send message", (Throwable)eee);
                }
            }
        }

        @Override
        public void putWikitty(WikittyServiceEvent event) {
            if (this.propagateEvent) {
                this.sendMessage(event);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Not master cache, do not propagate putWikitty event");
            }
        }

        @Override
        public void removeWikitty(WikittyServiceEvent event) {
            if (this.propagateEvent) {
                this.sendMessage(event);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Not master cache, do not propagate removeWikitty event");
            }
        }

        @Override
        public void clearWikitty(WikittyServiceEvent event) {
            if (this.propagateEvent) {
                this.sendMessage(event);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Not master cache, do not propagate clearWikitty event");
            }
        }

        @Override
        public void putExtension(WikittyServiceEvent event) {
            if (this.propagateEvent) {
                this.sendMessage(event);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Not master cache, do not propagate putExtension event");
            }
        }

        @Override
        public void removeExtension(WikittyServiceEvent event) {
            if (this.propagateEvent) {
                this.sendMessage(event);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Not master cache, do not propagate removeExtension event");
            }
        }

        @Override
        public void clearExtension(WikittyServiceEvent event) {
            if (this.propagateEvent) {
                this.sendMessage(event);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Not master cache, do not propagate clearExtension event");
            }
        }
    }

    public static interface RemoteNotifierTransporter {
        public void sendMessage(WikittyServiceEvent var1) throws Exception;
    }

    public static class EventThread
    extends Thread {
        protected boolean mustBeRunning = true;
        protected SortedMap<Long, Object> waiter = new TreeMap<Long, Object>();
        protected LinkedBlockingQueue<WikittyServiceEvent> eventToSend;
        protected ListenerSet<WikittyServiceListener> allWikittyServiceListeners;
        protected ListenerSet<WikittyServiceListener> localWikittyServiceListeners;
        protected ListenerSet<WikittyServiceListener> remoteWikittyServiceListeners;
        protected long lastEventTime = 0L;

        public EventThread(LinkedBlockingQueue<WikittyServiceEvent> eventToSend, ListenerSet<WikittyServiceListener> allWikittyServiceListeners, ListenerSet<WikittyServiceListener> localWikittyServiceListeners, ListenerSet<WikittyServiceListener> remoteWikittyServiceListeners) {
            super("wikitty-event-thread");
            this.eventToSend = eventToSend;
            this.allWikittyServiceListeners = allWikittyServiceListeners;
            this.localWikittyServiceListeners = localWikittyServiceListeners;
            this.remoteWikittyServiceListeners = remoteWikittyServiceListeners;
        }

        protected void askStop() {
            this.mustBeRunning = false;
        }

        public boolean stopAsked() {
            return !this.mustBeRunning;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitFor(long eventTime) throws InterruptedException {
            Object mutex = null;
            EventThread.sleep(1L);
            Object object = this.waiter;
            synchronized (object) {
                if (eventTime <= this.lastEventTime) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("event deja passe " + eventTime + " <= " + this.lastEventTime));
                    }
                    return;
                }
                mutex = this.waiter.get(eventTime);
                if (mutex == null) {
                    mutex = new Object();
                    this.waiter.put(eventTime, mutex);
                }
            }
            object = mutex;
            synchronized (object) {
                mutex.wait();
            }
        }

        @Override
        public void run() {
            while (this.mustBeRunning) {
                this.processEventQueue();
            }
            this.processEventQueue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        protected void processEventQueue() {
            try {
                WikittyServiceEvent event;
                while (null != (event = this.eventToSend.poll(5L, TimeUnit.SECONDS))) {
                    Object object;
                    Object mutex;
                    Object object2;
                    try {
                        object2 = this.allWikittyServiceListeners;
                        // MONITORENTER : object2
                        this.allWikittyServiceListeners.fire(event.getType().listenerMethodName, (Object)event);
                        // MONITOREXIT : object2
                    }
                    catch (Exception eee) {
                        log.error((Object)"Can't notify listener", (Throwable)eee);
                    }
                    try {
                        ListenerSet<WikittyServiceListener> eee;
                        if (event.isRemote()) {
                            eee = this.remoteWikittyServiceListeners;
                            // MONITORENTER : eee
                            this.remoteWikittyServiceListeners.fire(event.getType().listenerMethodName, (Object)event);
                            // MONITOREXIT : eee
                        } else {
                            eee = this.localWikittyServiceListeners;
                            // MONITORENTER : eee
                            this.localWikittyServiceListeners.fire(event.getType().listenerMethodName, (Object)event);
                            // MONITOREXIT : eee
                        }
                    }
                    catch (Exception eee) {
                        log.error((Object)"Can't notify listener", (Throwable)eee);
                    }
                    object2 = this.waiter;
                    // MONITORENTER : object2
                    this.lastEventTime = event.getTime();
                    SortedMap<Long, Object> subwaiter = this.waiter.headMap(event.getTime());
                    Iterator<Map.Entry<Long, Object>> i = subwaiter.entrySet().iterator();
                    while (i.hasNext()) {
                        mutex = i.next().getValue();
                        i.remove();
                        object = mutex;
                        // MONITORENTER : object
                        mutex.notifyAll();
                        // MONITOREXIT : object
                    }
                    if (!this.waiter.isEmpty()) {
                        Long time = this.waiter.firstKey();
                        while (time.equals(event.getTime())) {
                            object = mutex = this.waiter.remove(time);
                            // MONITORENTER : object
                            mutex.notifyAll();
                            // MONITOREXIT : object
                            if (this.waiter.isEmpty()) break;
                            time = this.waiter.firstKey();
                        }
                    }
                    // MONITOREXIT : object2
                }
                return;
            }
            catch (InterruptedException eee) {
                log.error((Object)"Notification thread error", (Throwable)eee);
            }
        }
    }
}

