/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.entities.GroupFormsImpl;
import com.jurismarches.vradi.entities.RootThesaurusImpl;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.Thesaurus;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyExtensionMigration;
import org.nuiton.wikitty.WikittyExtensionMigrationRename;
import org.nuiton.wikitty.WikittyImpl;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyTransaction;
import org.nuiton.wikitty.WikittyTreeNodeImpl;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;

public class ServiceMigration {
    private static final Log log = LogFactory.getLog(ServiceMigration.class);

    public static void configureMigration() {
        ServiceMigration.configureMigration010();
        ServiceMigration.configureMigration021();
    }

    protected static void configureMigration010() {
        WikittyExtensionMigration.migrationRegistry.put("VradiUser", new MigrationVradiUser());
        WikittyExtensionMigration.migrationRegistry.put("User", new MigrationUser());
        WikittyExtensionMigration.migrationRegistry.put("Sending", new MigrationSending());
    }

    protected static void configureMigration021() {
        WikittyExtensionMigration.migrationRegistry.put("Sending", new MigrationSendingV8());
    }

    public static void versionChangeMigration(String lastVersion, String currentVersion, WikittyProxy localWikittyProxy) {
        Search search;
        Criteria criteria;
        if (log.isDebugEnabled()) {
            log.debug((Object)("versionChangeMigration, old " + lastVersion + " current " + currentVersion));
        }
        if ("0.0.5".equals(lastVersion) && "0.1.0".equals(currentVersion)) {
            WikittyTreeNodeImpl rootThesaurus;
            if (log.isInfoEnabled()) {
                log.info((Object)"Migration root Thesaurus node : add RootThesaurus extension");
            }
            if ((rootThesaurus = (WikittyTreeNodeImpl)localWikittyProxy.findByCriteria(WikittyTreeNodeImpl.class, criteria = (search = Search.query().eq(Element.ELT_EXTENSION, "WikittyTreeNode").eq("WikittyTreeNode.name", "Thesaurus")).criteria())) != null) {
                if (!rootThesaurus.getWikitty().hasExtension("RootThesaurus")) {
                    rootThesaurus.getWikitty().addExtension(RootThesaurusImpl.extensionRootThesaurus);
                    rootThesaurus.setName("Thesaurus");
                    localWikittyProxy.store((BusinessEntity)rootThesaurus);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)"Set rootThesaurus id to all existing thesaurus");
                }
                search = Search.query().eq(Element.ELT_EXTENSION, "Thesaurus");
                criteria = search.criteria();
                List thesauruses = localWikittyProxy.findAllByCriteria(Thesaurus.class, criteria).getAll();
                for (Thesaurus thesaurus : thesauruses) {
                    thesaurus.setRootThesaurus(rootThesaurus.getWikittyId());
                }
                localWikittyProxy.store(thesauruses);
            }
            Criteria criteriaStatus = Search.query().eq(Element.ELT_EXTENSION, "Status").criteria();
            List statuses = localWikittyProxy.findAllByCriteria(Status.class, criteriaStatus).getAll();
            ArrayList<String> statusesIds = new ArrayList<String>();
            for (Status status : statuses) {
                statusesIds.add(status.getWikittyId());
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Deleting status " + status.getName()));
            }
            localWikittyProxy.delete(statusesIds);
        }
        if (!currentVersion.equals(lastVersion) && currentVersion.matches("0\\.3\\.0.+")) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Sendings migration");
            }
            search = Search.query().eq(Element.ELT_EXTENSION, "Sending");
            criteria = search.criteria();
            List sendings = localWikittyProxy.findAllByCriteria(Sending.class, criteria).getAll();
            for (Sending sending : sendings) {
                if (sending == null) continue;
                Wikitty wikitty = sending.getWikitty();
                Set fqFieldNames = wikitty.fieldNames();
                for (String fieldName : fqFieldNames) {
                    Wikitty groupFormsWikitty;
                    GroupFormsImpl groupFormCreated;
                    Object value;
                    if (fieldName.equals("Sending.form")) {
                        value = wikitty.getFqField(fieldName);
                        groupFormCreated = new GroupFormsImpl();
                        groupFormsWikitty = groupFormCreated.getWikitty();
                        groupFormsWikitty.setFqField("GroupForms.form", value);
                        localWikittyProxy.store((BusinessEntity)groupFormCreated);
                        sending.addGroupForms(groupFormCreated.getWikittyId());
                        continue;
                    }
                    if (!fieldName.equals("Sending.deletedForms")) continue;
                    value = wikitty.getFqField(fieldName);
                    groupFormCreated = new GroupFormsImpl();
                    groupFormsWikitty = groupFormCreated.getWikitty();
                    groupFormsWikitty.setFqField("GroupForms.form", value);
                    localWikittyProxy.store((BusinessEntity)groupFormCreated);
                    sending.addDeletedGroupForms(groupFormCreated.getWikittyId());
                }
                localWikittyProxy.store((BusinessEntity)sending);
            }
        }
    }

    static class MigrationSendingV8
    extends WikittyExtensionMigrationRename {
        MigrationSendingV8() {
        }

        public Wikitty migrate(WikittyService service, WikittyTransaction transaction, Wikitty wikitty, WikittyExtension oldExt, WikittyExtension newExt) {
            Set fqFieldNames;
            if (log.isDebugEnabled()) {
                log.debug((Object)("migrate, old " + oldExt + " new " + newExt));
            }
            String wikittyId = wikitty.getId();
            String wikittyVersion = wikitty.getVersion();
            WikittyImpl result = new WikittyImpl(wikittyId);
            result.setVersion(wikittyVersion);
            for (WikittyExtension extension : wikitty.getExtensions()) {
                if (extension.equals((Object)oldExt)) {
                    this.addExtension(service, transaction, (Wikitty)result, newExt);
                    continue;
                }
                this.addExtension(service, transaction, (Wikitty)result, extension);
            }
            if (oldExt.getVersion().equals("4.0") || oldExt.getVersion().equals("5.0") || oldExt.getVersion().equals("6.0") || oldExt.getVersion().equals("7.0")) {
                fqFieldNames = wikitty.fieldNames();
                for (String fieldName : fqFieldNames) {
                    if (fieldName.equals("Sending.form") || fieldName.equals("Sending.deletedForms") || fieldName.equals("Sending.addedForms") || fieldName.equals("Sending.groupsConcerned")) continue;
                    Object value = wikitty.getFqField(fieldName);
                    result.setFqField(fieldName, value);
                }
            } else {
                fqFieldNames = wikitty.fieldNames();
                for (String fieldName : fqFieldNames) {
                    Object value = wikitty.getFqField(fieldName);
                    result.setFqField(fieldName, value);
                }
            }
            return result;
        }

        protected void addExtentions(WikittyService service, WikittyTransaction transaction, Wikitty groupFormsWikitty) {
            for (WikittyExtension extension : groupFormsWikitty.getExtensions()) {
                this.addExtension(service, transaction, groupFormsWikitty, extension);
            }
        }
    }

    static class MigrationSending
    extends WikittyExtensionMigrationRename {
        MigrationSending() {
        }

        public Wikitty migrate(WikittyService service, WikittyTransaction transaction, Wikitty wikitty, WikittyExtension oldExt, WikittyExtension newExt) {
            Set fqFieldNames;
            String wikittyId = wikitty.getId();
            String wikittyVersion = wikitty.getVersion();
            WikittyImpl result = new WikittyImpl(wikittyId);
            result.setVersion(wikittyVersion);
            for (WikittyExtension extension : wikitty.getExtensions()) {
                if (extension.equals((Object)oldExt)) {
                    this.addExtension(service, transaction, (Wikitty)result, newExt);
                    continue;
                }
                this.addExtension(service, transaction, (Wikitty)result, extension);
            }
            if (oldExt.getVersion().equals("3.0")) {
                fqFieldNames = wikitty.fieldNames();
                for (String fieldName : fqFieldNames) {
                    Object value;
                    if (fieldName.equals("Sending.queryMaker")) {
                        value = wikitty.getFqField(fieldName);
                        result.setFqField("Sending.user", value);
                        continue;
                    }
                    value = wikitty.getFqField(fieldName);
                    result.setFqField(fieldName, value);
                }
            } else {
                fqFieldNames = wikitty.fieldNames();
                for (String fieldName : fqFieldNames) {
                    Object value = wikitty.getFqField(fieldName);
                    result.setFqField(fieldName, value);
                }
            }
            return result;
        }
    }

    static class MigrationUser
    extends WikittyExtensionMigrationRename {
        MigrationUser() {
        }

        public Wikitty migrate(WikittyService service, WikittyTransaction transaction, Wikitty wikitty, WikittyExtension oldExt, WikittyExtension newExt) {
            Set fqFieldNames;
            String wikittyId = wikitty.getId();
            String wikittyVersion = wikitty.getVersion();
            WikittyImpl result = new WikittyImpl(wikittyId);
            result.setVersion(wikittyVersion);
            for (WikittyExtension extension : wikitty.getExtensions()) {
                if (extension.equals((Object)oldExt)) {
                    this.addExtension(service, transaction, (Wikitty)result, newExt);
                    continue;
                }
                this.addExtension(service, transaction, (Wikitty)result, extension);
            }
            if (oldExt.getVersion().equals("6.0")) {
                fqFieldNames = wikitty.fieldNames();
                for (String fieldName : fqFieldNames) {
                    Object value;
                    if (fieldName.equals("User.inscriptionDate")) {
                        value = wikitty.getFqField(fieldName);
                        result.setFqField("User.beginSearchDate", value);
                        continue;
                    }
                    value = wikitty.getFqField(fieldName);
                    result.setFqField(fieldName, value);
                }
            } else {
                fqFieldNames = wikitty.fieldNames();
                for (String fieldName : fqFieldNames) {
                    Object value = wikitty.getFqField(fieldName);
                    result.setFqField(fieldName, value);
                }
            }
            return result;
        }
    }

    static class MigrationVradiUser
    extends WikittyExtensionMigrationRename {
        MigrationVradiUser() {
        }

        public Wikitty migrate(WikittyService service, WikittyTransaction transaction, Wikitty wikitty, WikittyExtension oldExt, WikittyExtension newExt) {
            Set fqFieldNames;
            String wikittyId = wikitty.getId();
            String wikittyVersion = wikitty.getVersion();
            WikittyImpl result = new WikittyImpl(wikittyId);
            result.setVersion(wikittyVersion);
            for (WikittyExtension extension : wikitty.getExtensions()) {
                if (extension.equals((Object)oldExt)) {
                    this.addExtension(service, transaction, (Wikitty)result, newExt);
                    continue;
                }
                this.addExtension(service, transaction, (Wikitty)result, extension);
            }
            if (oldExt.getVersion().equals("1.0")) {
                fqFieldNames = wikitty.fieldNames();
                for (String fieldName : fqFieldNames) {
                    Object value;
                    if (fieldName.equals("VradiUser.name")) {
                        value = wikitty.getFqField(fieldName);
                        result.setFqField("WikittyUser.login", value);
                        continue;
                    }
                    if (fieldName.equals("VradiUser.password")) {
                        value = wikitty.getFqField(fieldName);
                        result.setFqField("WikittyUser.password", value);
                        continue;
                    }
                    value = wikitty.getFqField(fieldName);
                    result.setFqField(fieldName, value);
                }
            } else {
                fqFieldNames = wikitty.fieldNames();
                for (String fieldName : fqFieldNames) {
                    Object value = wikitty.getFqField(fieldName);
                    result.setFqField(fieldName, value);
                }
            }
            return result;
        }
    }
}

