/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyImpl;
import org.nuiton.wikitty.WikittyService;

public class WikittyUtil {
    public static final String DEFAULT_MAJOR_VERSION = "0";
    public static final String DEFAULT_MINOR_VERSION = "0";
    public static final String DEFAULT_MAJOR_VERSION_PREFIX = "0.";
    public static final String DEFAULT_VERSION = "0.0";
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ'Z'";
    public static final String[] DATE_FORMAT_ALLOWED = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSZ'Z'", new SimpleDateFormat().toPattern(), "dd/MM/yy"};
    private static Log log = LogFactory.getLog(WikittyUtil.class);
    protected static TimeZone CANONICAL_TZ = TimeZone.getTimeZone("UTC");
    protected static final Locale CANONICAL_LOCALE = Locale.US;
    protected static final FastDateFormat solrDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ'Z'", (TimeZone)CANONICAL_TZ, (Locale)CANONICAL_LOCALE);
    protected static final String FQ_FIELD_NAME_SEPARATOR = ".";
    protected static final String FQ_FIELD_NAME_SEPARATOR_REGEX = "\\.";
    protected static final String FQ_META_EXTENSION_SEPARATOR = ":";
    protected static final String FQ_META_EXTENSION_SEPARATOR_REGEX = ":";
    public static Map<Class<?>, Class<?>> interfaceToClass = new HashMap();
    protected static String tagValuesPatternString = "(\\w*)=(\".*?(?<!\\\\)\"|[^(\\p{Space})]+)";
    protected static Pattern tagValuesPattern = Pattern.compile(tagValuesPatternString, 32);
    protected static Pattern fieldPattern = Pattern.compile("\\s*(\\w+)\\s+(\\w+)(?:\\s*\\[(\\d+)-(?:(\\d+)|([\\*n]))\\])?(?:\\s+(unique))?(?:\\s+(not null))?((?:\\s+" + tagValuesPatternString + ")*)", 32);

    public static Date parseDate(String dateAsString) throws ParseException {
        return DateUtils.parseDate((String)dateAsString, (String[])DATE_FORMAT_ALLOWED);
    }

    public static String formatDate(Date date) throws ParseException {
        return solrDateFormat.format(date);
    }

    public static String parseField(String def, FieldType fieldType) {
        Matcher match = fieldPattern.matcher(def);
        if (match.matches()) {
            String notNullString;
            String noupper;
            String upper;
            fieldType.type = FieldType.TYPE.parse(match.group(1));
            String name = match.group(2);
            String lower = match.group(3);
            if (lower != null) {
                fieldType.lowerBound = Integer.parseInt(lower);
            }
            if ((upper = match.group(4)) != null) {
                fieldType.upperBound = Integer.parseInt(upper);
            }
            if ((noupper = match.group(5)) != null) {
                fieldType.upperBound = Integer.MAX_VALUE;
            }
            String tagValues = match.group(8);
            Map<String, String> tagValuesMap = WikittyUtil.tagValuesToMap(tagValues);
            String uniqueString = match.group(6);
            if (uniqueString != null) {
                tagValuesMap.put(FieldType.UNIQUE, "true");
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Old field constraints definition detected \"unique\" ; prefer use of \"unique=true\"");
                }
            }
            if ((notNullString = match.group(7)) != null) {
                tagValuesMap.put(FieldType.NOT_NULL, "true");
                log.warn((Object)"Old field constraints definition detected \"non null\" ; prefer use of \"notNull=true\"");
            }
            fieldType.setTagValues(tagValuesMap);
            return name;
        }
        throw new WikittyException(String.format("Bad FieldType definition '%s'", def));
    }

    public static String tagValuesToString(Map<String, String> tagValues) {
        String result = "";
        if (tagValues != null) {
            for (String tag : tagValues.keySet()) {
                String value = tagValues.get(tag);
                value = value.replaceAll("\"", "\\\\\"");
                result = result + " " + tag + "=\"" + tagValues.get(tag) + "\"";
            }
        }
        return result;
    }

    public static Map<String, String> tagValuesToMap(String tagValues) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (tagValues != null) {
            Matcher matchTagValues = tagValuesPattern.matcher(tagValues);
            while (matchTagValues.find()) {
                String tag = matchTagValues.group(1);
                String value = matchTagValues.group(2);
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                    value = value.replaceAll("\\\\\"", "\"");
                }
                result.put(tag, value);
            }
        }
        return result;
    }

    public static LinkedHashMap<String, FieldType> buildFieldMapExtension(String ... definitions) {
        LinkedHashMap<String, FieldType> result = new LinkedHashMap<String, FieldType>();
        for (String def : definitions) {
            FieldType fieldType = new FieldType();
            String name = WikittyUtil.parseField(def, fieldType);
            if (log.isDebugEnabled()) {
                log.debug((Object)("parse " + def + " => " + fieldType.toDefinition(name)));
            }
            result.put(name, fieldType);
        }
        return result;
    }

    public static String normalizeVersion(String version) {
        if (version == null || "".equals(version)) {
            version = "0";
        }
        if (version.indexOf(FQ_FIELD_NAME_SEPARATOR) == -1) {
            version = version + ".0";
        }
        return version;
    }

    public static boolean versionEquals(String v1, String v2) {
        if (v1 == null || v2 == null) {
            return false;
        }
        return WikittyUtil.normalizeVersion(v1).equals(WikittyUtil.normalizeVersion(v2));
    }

    public static boolean versionGreaterThan(String v1, String v2) {
        if (v1 != null && v2 == null) {
            return true;
        }
        if (v1 == null) {
            return false;
        }
        String[] v1s = WikittyUtil.normalizeVersion(v1).split(FQ_FIELD_NAME_SEPARATOR_REGEX);
        String[] v2s = WikittyUtil.normalizeVersion(v2).split(FQ_FIELD_NAME_SEPARATOR_REGEX);
        int minlen = Math.min(v1s.length, v2s.length);
        for (int i = 0; i < minlen; ++i) {
            if (v1s[i].equals(v2s[i])) continue;
            return Integer.parseInt(v1s[i]) > Integer.parseInt(v2s[i]);
        }
        return v1s.length > v2s.length;
    }

    public static String incrementMinorRevision(String v) {
        String result;
        if (v == null || "".equals(v)) {
            result = "0.1";
        } else {
            String[] mm = (v = v.trim()).split(FQ_FIELD_NAME_SEPARATOR_REGEX);
            if (mm.length == 1) {
                result = v + ".1";
            } else {
                int i = Integer.parseInt(mm[1]) + 1;
                result = mm[0] + FQ_FIELD_NAME_SEPARATOR + i;
            }
        }
        return result;
    }

    public static String incrementMajorRevision(String v) {
        String result;
        if (v == null || "".equals(v)) {
            result = "1.0";
        } else {
            v = v.trim();
            String[] mm = v.split(FQ_FIELD_NAME_SEPARATOR_REGEX);
            int i = Integer.parseInt(mm[0]) + 1;
            result = i + ".0";
        }
        return result;
    }

    public static BigDecimal toBigDecimal(Object value) {
        BigDecimal result = null;
        if (value == null) {
            result = new BigDecimal(0);
        } else if (value instanceof BigDecimal) {
            result = (BigDecimal)value;
        } else {
            try {
                result = new BigDecimal(value.toString());
            }
            catch (NumberFormatException eee) {
                throw new WikittyException(String.format("Can't convert value '%s' to numeric", WikittyUtil.getClass(value)), eee);
            }
        }
        return result;
    }

    public static boolean toBoolean(Object value) {
        boolean result = false;
        if (value != null) {
            result = value instanceof Boolean ? (Boolean)value : (value instanceof Number ? !((Number)value).equals(0) : !"false".equalsIgnoreCase(value.toString()));
        }
        return result;
    }

    public static String toString(Object value) {
        String result = null;
        if (value != null) {
            result = value instanceof String ? (String)value : (value instanceof WikittyImpl ? ((Wikitty)value).getId() : (value instanceof BusinessEntity ? ((BusinessEntity)value).getWikittyId() : (value instanceof Date ? solrDateFormat.format((Date)value) : value.toString())));
        }
        return result;
    }

    public static Date toDate(Object value) {
        Date result = null;
        if (value != null) {
            if (value instanceof Date) {
                result = (Date)value;
            } else {
                block6: {
                    try {
                        result = WikittyUtil.parseDate(value.toString());
                    }
                    catch (ParseException eee) {
                        if (!log.isDebugEnabled()) break block6;
                        log.debug((Object)"Can't parse date, i try with next parser", (Throwable)eee);
                    }
                }
                if (result == null) {
                    throw new WikittyException(String.format("Can't convert value '%s' of type '%s' to Date", value, WikittyUtil.getClass(value)));
                }
            }
        }
        return result;
    }

    public static String toWikitty(Object value) {
        String result = null;
        if (value != null) {
            result = value instanceof String ? (String)value : (value instanceof WikittyImpl ? ((Wikitty)value).getId() : (value instanceof BusinessEntity ? ((BusinessEntity)value).getWikittyId() : value.toString()));
        }
        return result;
    }

    public static <E> List<E> toList(Object value, Class<E> clazz) {
        try {
            List result = (List)value;
            if (result != null) {
                result = Collections.unmodifiableList(result);
            }
            return result;
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't convert value '%s' to list", WikittyUtil.getClass(value)), eee);
        }
    }

    public static String toString(FieldType field, Object o) {
        String result = null;
        if (o != null) {
            switch (field.getType()) {
                case DATE: {
                    result = o instanceof String ? (String)o : solrDateFormat.format((Date)o);
                    break;
                }
                default: {
                    result = WikittyUtil.toString(o);
                }
            }
        }
        return result;
    }

    public static Object fromString(FieldType field, String s) {
        Object result = null;
        switch (field.getType()) {
            case BOOLEAN: {
                result = WikittyUtil.toBoolean(s);
                break;
            }
            case DATE: {
                result = WikittyUtil.toDate(s);
                break;
            }
            case NUMERIC: {
                result = WikittyUtil.toBigDecimal(s);
                break;
            }
            default: {
                result = s;
            }
        }
        return result;
    }

    public static Class<?> getClass(Object value) {
        Class<?> result = null;
        if (value != null) {
            result = value.getClass();
        }
        return result;
    }

    public static <E extends BusinessEntity> E newInstance(Class<E> clazz) {
        try {
            Class<Object> clazzInstanciable = clazz;
            if (clazzInstanciable.isInterface()) {
                log.debug((Object)String.format("Argument '%s' is interface looking for implementation", clazzInstanciable.getName()));
                clazzInstanciable = interfaceToClass.containsKey(clazz) ? interfaceToClass.get(clazz) : Class.forName(clazz.getName() + "Impl");
            }
            if (!BusinessEntityWikitty.class.isAssignableFrom(clazzInstanciable)) {
                throw new WikittyException(String.format("Your class '%s' don't extends WikittyDto", clazz.getName()));
            }
            BusinessEntity result = (BusinessEntity)clazzInstanciable.newInstance();
            return (E)result;
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't create new instance of %s", clazz), eee);
        }
    }

    public static <E extends BusinessEntity> E newInstance(String securityToken, WikittyService wikittyService, Class<E> clazz, Wikitty w) {
        try {
            BusinessEntity result;
            block7: {
                Class<Object> clazzInstanciable = clazz;
                if (clazzInstanciable.isInterface()) {
                    log.debug((Object)String.format("Argument '%s' is interface looking for implementation", clazzInstanciable.getName()));
                    clazzInstanciable = interfaceToClass.containsKey(clazz) ? interfaceToClass.get(clazz) : Class.forName(clazz.getName() + "Impl");
                }
                if (!BusinessEntityWikitty.class.isAssignableFrom(clazzInstanciable)) {
                    throw new WikittyException(String.format("Your class '%s' don't extends WikittyDto", clazz.getName()));
                }
                result = null;
                if (w != null) {
                    try {
                        Constructor<E> cons = clazzInstanciable.getConstructor(Wikitty.class);
                        Object[] parms = new Object[]{null};
                        result = (BusinessEntity)cons.newInstance(parms);
                        BusinessEntityWikitty bean = (BusinessEntityWikitty)result;
                        WikittyUtil.checkExtensionVersion(securityToken, wikittyService, w, bean);
                        bean.setWikitty(w);
                    }
                    catch (NoSuchMethodException noerror) {
                        if (!log.isErrorEnabled()) break block7;
                        log.error((Object)String.format("Can't find constructor with wikitty arguement in '%s',we try with setWikitty method", clazzInstanciable.getName()), (Throwable)noerror);
                    }
                }
            }
            return (E)result;
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't create new instance of %s", clazz), eee);
        }
    }

    public static Wikitty checkExtensionVersion(String securityToken, WikittyService wikittyService, Wikitty wikitty, BusinessEntityWikitty entity) {
        Wikitty result = wikitty;
        boolean upgradeData = false;
        Collection<WikittyExtension> extensions = entity.getStaticExtensions();
        for (WikittyExtension ext : extensions) {
            String oldVersion;
            String extName = ext.getName();
            if (!wikitty.hasExtension(extName)) continue;
            WikittyExtension oldExt = wikitty.getExtension(extName);
            String newVersion = ext.getVersion();
            if (!WikittyUtil.versionGreaterThan(newVersion, oldVersion = oldExt.getVersion())) continue;
            wikittyService.storeExtension(securityToken, Arrays.asList(ext));
            upgradeData = true;
        }
        if (upgradeData) {
            String wikittyId = wikitty.getId();
            result = wikittyService.restore(securityToken, wikittyId);
        }
        return result;
    }

    public static <E> E cast(Object obj, Class<E> clazz) {
        E result = null;
        if (obj != null) {
            if (clazz.isAssignableFrom(obj.getClass())) {
                result = clazz.cast(obj);
            } else if (obj instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)obj;
                if (clazz == Integer.TYPE || clazz == Integer.class) {
                    result = clazz.cast(bd.intValue());
                } else if (clazz == Float.TYPE || clazz == Float.class) {
                    result = clazz.cast(Float.valueOf(bd.floatValue()));
                }
            }
            if (result == null) {
                throw new WikittyException("Unable to cast from '" + obj.getClass().getName() + "' to " + clazz.getName());
            }
        }
        return result;
    }

    public static String genSecurityTokenId() {
        String result = "_" + Math.abs(Math.random());
        result.replace(FQ_FIELD_NAME_SEPARATOR, "");
        result = WikittyUtil.genUID() + result;
        return result;
    }

    public static String genUID() {
        return UUID.randomUUID().toString();
    }

    public static String getExtensionNameFromFQFieldName(String fqFieldName) {
        String[] fqFieldElements = fqFieldName.split(FQ_FIELD_NAME_SEPARATOR_REGEX);
        return fqFieldElements[0];
    }

    public static String getFieldNameFromFQFieldName(String fqFieldName) {
        String[] fqFieldElements = fqFieldName.split(FQ_FIELD_NAME_SEPARATOR_REGEX);
        return fqFieldElements[1];
    }

    public static String getFQFieldName(String extensionName, String fieldName) {
        String fqFieldName = extensionName + FQ_FIELD_NAME_SEPARATOR + fieldName;
        return fqFieldName;
    }

    public static String getMetaExtensionNameFromFQMetaExtensionName(String fqFieldName) {
        String metaExtensionName = null;
        if (fqFieldName.indexOf(":") != -1) {
            String[] fqElements = fqFieldName.split(":");
            metaExtensionName = fqElements[1];
        }
        return metaExtensionName;
    }

    public static String getExtensionNameFromFQMetaExtensionName(String fqFieldName) {
        String[] fqElements = fqFieldName.split(":");
        return fqElements[0];
    }

    public static String getFQMetaExtensionName(String metaExtensionName, String extensionName) {
        String fqFieldName = extensionName + ":" + metaExtensionName;
        return fqFieldName;
    }

    public static String getMetaFieldName(String metaExtensionName, String extensionName, String fieldName) {
        String actualExtensionName = metaExtensionName;
        if (extensionName != null) {
            actualExtensionName = WikittyUtil.getFQMetaExtensionName(metaExtensionName, extensionName);
        }
        String metaFieldName = WikittyUtil.getFQFieldName(actualExtensionName, fieldName);
        return metaFieldName;
    }
}

