/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.Name11Checker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.QNameException;
import org.xml.sax.Attributes;

public final class AttributeCollectionImpl
implements Attributes,
AttributeCollection {
    private NamePool namePool;
    private LocationProvider locationProvider;
    private String[] values = null;
    private int[] codes = null;
    private int used = 0;
    public static final AttributeCollection EMPTY_ATTRIBUTE_COLLECTION = new AttributeCollectionImpl(null);
    private static final int RECSIZE = 4;
    private static final int NAMECODE = 0;
    private static final int TYPECODE = 1;
    private static final int LOCATIONID = 2;
    private static final int PROPERTIES = 3;

    public AttributeCollectionImpl(NamePool namePool) {
        this.namePool = namePool;
        this.used = 0;
    }

    public void setLocationProvider(LocationProvider locationProvider) {
        this.locationProvider = locationProvider;
    }

    public void addAttribute(int n, int n2, String string, int n3, int n4) {
        int n5;
        if (this.values == null) {
            this.values = new String[5];
            this.codes = new int[20];
            this.used = 0;
        }
        if (this.values.length == this.used) {
            n5 = this.used == 0 ? 5 : this.used * 2;
            String[] stringArray = new String[n5];
            int[] nArray = new int[n5 * 4];
            System.arraycopy(this.values, 0, stringArray, 0, this.used);
            System.arraycopy(this.codes, 0, nArray, 0, this.used * 4);
            this.values = stringArray;
            this.codes = nArray;
        }
        n5 = this.used * 4;
        this.codes[n5 + 0] = n;
        this.codes[n5 + 1] = n2;
        this.codes[n5 + 2] = n3;
        this.codes[n5 + 3] = n4;
        this.values[this.used++] = string;
    }

    public void setAttribute(int n, int n2, int n3, String string, int n4, int n5) {
        int n6 = n * 4;
        this.codes[n6 + 0] = n2;
        this.codes[n6 + 1] = n3;
        this.codes[n6 + 2] = n4;
        this.codes[n6 + 3] = n5;
        this.values[n] = string;
    }

    public void clear() {
        this.used = 0;
    }

    public void compact() {
        if (this.used == 0) {
            this.codes = null;
            this.values = null;
        } else if (this.values.length > this.used) {
            String[] stringArray = new String[this.used];
            int[] nArray = new int[this.used * 4];
            System.arraycopy(this.values, 0, stringArray, 0, this.used);
            System.arraycopy(this.codes, 0, nArray, 0, this.used * 4);
            this.values = stringArray;
            this.codes = nArray;
        }
    }

    public int getLength() {
        return this.values == null ? 0 : this.used;
    }

    public int getNameCode(int n) {
        if (this.codes == null) {
            return -1;
        }
        if (n < 0 || n >= this.used) {
            return -1;
        }
        return this.codes[n * 4 + 0];
    }

    public int getTypeAnnotation(int n) {
        if (this.codes == null) {
            return 642;
        }
        if (n < 0 || n >= this.used) {
            return 642;
        }
        return this.codes[n * 4 + 1];
    }

    public int getLocationId(int n) {
        if (this.codes == null) {
            return -1;
        }
        if (n < 0 || n >= this.used) {
            return -1;
        }
        return this.codes[n * 4 + 2];
    }

    public String getSystemId(int n) {
        return this.locationProvider.getSystemId(this.getLocationId(n));
    }

    public int getLineNumber(int n) {
        return this.locationProvider.getLineNumber(this.getLocationId(n));
    }

    public int getProperties(int n) {
        if (this.codes == null) {
            return -1;
        }
        if (n < 0 || n >= this.used) {
            return -1;
        }
        return this.codes[n * 4 + 3];
    }

    public String getPrefix(int n) {
        if (this.codes == null) {
            return null;
        }
        if (n < 0 || n >= this.used) {
            return null;
        }
        return this.namePool.getPrefix(this.getNameCode(n));
    }

    public String getQName(int n) {
        if (this.codes == null) {
            return null;
        }
        if (n < 0 || n >= this.used) {
            return null;
        }
        return this.namePool.getDisplayName(this.getNameCode(n));
    }

    public String getLocalName(int n) {
        if (this.codes == null) {
            return null;
        }
        if (n < 0 || n >= this.used) {
            return null;
        }
        return this.namePool.getLocalName(this.getNameCode(n));
    }

    public String getURI(int n) {
        if (this.codes == null) {
            return null;
        }
        if (n < 0 || n >= this.used) {
            return null;
        }
        return this.namePool.getURI(this.getNameCode(n));
    }

    public String getType(int n) {
        int n2 = this.getTypeAnnotation(n) & 0xFFFFF;
        switch (n2) {
            case 560: {
                return "ID";
            }
            case 561: {
                return "IDREF";
            }
            case 556: {
                return "NMTOKEN";
            }
            case 563: {
                return "ENTITY";
            }
            case 562: {
                return "IDREFS";
            }
            case 557: {
                return "NMTOKENS";
            }
            case 564: {
                return "ENTITIES";
            }
        }
        return "CDATA";
    }

    public String getType(String string, String string2) {
        int n = this.findByName(string, string2);
        return n < 0 ? null : this.getType(n);
    }

    public String getValue(int n) {
        if (this.values == null) {
            return null;
        }
        if (n < 0 || n >= this.used) {
            return null;
        }
        return this.values[n];
    }

    public String getValue(String string, String string2) {
        int n = this.findByName(string, string2);
        return n < 0 ? null : this.getValue(n);
    }

    public String getValueByFingerprint(int n) {
        int n2 = this.findByFingerprint(n);
        return n2 < 0 ? null : this.getValue(n2);
    }

    public int getIndex(String string) {
        String[] stringArray;
        if (this.codes == null) {
            return -1;
        }
        if (string.indexOf(58) < 0) {
            return this.findByName("", string);
        }
        try {
            stringArray = Name11Checker.getInstance().getQNameParts(string);
        }
        catch (QNameException qNameException) {
            return -1;
        }
        String string2 = stringArray[0];
        if (string2.equals("")) {
            return this.findByName("", string);
        }
        String string3 = stringArray[1];
        for (int i = 0; i < this.used; ++i) {
            String string4 = this.namePool.getLocalName(this.getNameCode(i));
            String string5 = this.namePool.getPrefix(this.getNameCode(i));
            if (!string3.equals(string4) || !string2.equals(string5)) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(String string, String string2) {
        return this.findByName(string, string2);
    }

    public int getIndexByFingerprint(int n) {
        return this.findByFingerprint(n);
    }

    public String getType(String string) {
        int n = this.getIndex(string);
        return this.getType(n);
    }

    public String getValue(String string) {
        int n = this.getIndex(string);
        return this.getValue(n);
    }

    private int findByName(String string, String string2) {
        if (this.namePool == null) {
            return -1;
        }
        int n = this.namePool.getFingerprint(string, string2);
        if (n == -1) {
            return -1;
        }
        return this.findByFingerprint(n);
    }

    private int findByFingerprint(int n) {
        if (this.codes == null) {
            return -1;
        }
        for (int i = 0; i < this.used; ++i) {
            if (n != (this.codes[i * 4 + 0] & 0xFFFFF)) continue;
            return i;
        }
        return -1;
    }

    public boolean isId(int n) {
        return this.getType(n).equals("ID") || (this.getNameCode(n) & 0xFFFFF) == 388;
    }
}

