package com.jurismarches.vradi.services.search;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang.math.NumberUtils;

/**
 * RangeFilter.
 *
 * @author $Author: schorlet $
 * @version $Revision: 602 $ $Date: 2010-03-04 15:25:31 +0100 (jeu., 04 mars 2010) $
 * @since 4 mars 2010 10:38:16
 */
public class RangeFilter extends CompareFilter {
    private static final long serialVersionUID = 1L;

    String lowerValue = null;
    String upperValue = null;
    
    public RangeFilter(String term, String lowerValue, String upperValue) {
        this.term = term;
        this.value = lowerValue;
        this.lowerValue = lowerValue;
        this.upperValue = upperValue;
    }
    
    @Override
    public void setValue(String value) {
        this.value = value;
        this.lowerValue = value;
    }
    
    public void setLowerValue(String value) {
        this.lowerValue = value;
    }
    public String getLowerValue() {
        return lowerValue;
    }
    
    public void setUpperValue(String value) {
        this.upperValue = value;
    }
    public String getUpperValue() {
        return upperValue;
    }
    
    @Override
    public boolean isNumber() {
        return NumberUtils.isNumber(lowerValue) && NumberUtils.isNumber(upperValue);
    }
    
    @Override
    public boolean match(Pattern pattern) {
        Matcher lowerMatcher = pattern.matcher(lowerValue);
        Matcher upperMatcher = pattern.matcher(upperValue);
        return lowerMatcher.matches() && upperMatcher.matches();
    }
    
    @Override
    public String toString() {
        return String.format("%s = [%s TO %s]", term, lowerValue, upperValue);
    }
}
