/*
 * *##% 
 * vradi-services
 * Copyright (C) 2009 JurisMarches
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.services.dto;

import org.sharengo.wikitty.WikittyExtension;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

/**
 * User: chemit
 * Date: 7 nov. 2009
 * Time: 15:10:02
 */
public class WikittyExtensionDTO extends WikittyExtension implements VradiDTO<WikittyExtension> {

    private static final long serialVersionUID = 1L;

    protected String id;

    public WikittyExtensionDTO() {
        super("");
    }

    @Override
    public void fromWikitty(WikittyExtension wikitty) {
        if (wikitty == null) {
            reset();
        } else {
            setId(wikitty.getId());
            setName(wikitty.getName());
            setRequires(wikitty.getRequires());
        }
    }

    public void reset() {
        setId(null);
        setName(null);
        setRequires(null);
    }

    @Override
    public void toWikitty(WikittyExtension wikitty) {

    }

    public void setId(String id) {
        String old = this.getId();
        this.id = id;
        propertyChange.firePropertyChange("id", old, id);
    }

    public void setRequires(String id) {
        String old = this.getRequires();
        this.requires = id;
        propertyChange.firePropertyChange("requires", old, id);
    }

    public void setName(String id) {
        String old = this.getName();
        this.name = id;
        propertyChange.firePropertyChange("name", old, id);
    }

    protected PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        propertyChange.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        propertyChange.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        propertyChange.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        propertyChange.removePropertyChangeListener(propertyName, listener);
    }

}