/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  class ModificationTagHelper {

    /**
     * ModificationTagHelper :
     * utility class all provided methods are accessible the static way
     */

    private ModificationTagHelper() {// empty
}

    /**
     * getLastModified :
     * @param wikitty 
     * @return Date 
     */

    public static Date getLastModified(Wikitty wikitty) {
        Date value = wikitty.getFieldAsDate(ModificationTag.EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTMODIFIED);
        return value;
}

    /**
     * setLastModified :
     * @param wikitty 
     * @param lastModified 
     * @return Date 
     */

    public static Date setLastModified(Wikitty wikitty, Date lastModified) {
        Date oldValue = getLastModified(wikitty);
        wikitty.setField(ModificationTag.EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTMODIFIED, lastModified);
        return oldValue;
}

    /**
     * getLastModifier :
     * @param wikitty 
     * @return String 
     */

    public static String getLastModifier(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(ModificationTag.EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTMODIFIER);
        return value;
}

    /**
     * setLastModifier :
     * @param wikitty 
     * @param lastModifier 
     * @return String 
     */

    public static String setLastModifier(Wikitty wikitty, String lastModifier) {
        String oldValue = getLastModifier(wikitty);
        wikitty.setField(ModificationTag.EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTMODIFIER, lastModifier);
        return oldValue;
}

    /**
     * getLastStatusModifier :
     * @param wikitty 
     * @return String 
     */

    public static String getLastStatusModifier(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(ModificationTag.EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTSTATUSMODIFIER);
        return value;
}

    /**
     * setLastStatusModifier :
     * @param wikitty 
     * @param lastStatusModifier 
     * @return String 
     */

    public static String setLastStatusModifier(Wikitty wikitty, String lastStatusModifier) {
        String oldValue = getLastStatusModifier(wikitty);
        wikitty.setField(ModificationTag.EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTSTATUSMODIFIER, lastStatusModifier);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(ModificationTag.EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTMODIFIED);
            Object f2 = w2.getFieldAsObject(ModificationTag.EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTMODIFIED);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(ModificationTag.EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTMODIFIER);
            Object f2 = w2.getFieldAsObject(ModificationTag.EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTMODIFIER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(ModificationTag.EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTSTATUSMODIFIER);
            Object f2 = w2.getFieldAsObject(ModificationTag.EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTSTATUSMODIFIER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(ModificationTag.EXT_MODIFICATIONTAG);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : ModificationTagAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //ModificationTagHelper
