/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class GroupFormsAbstract extends BusinessEntityImpl implements GroupForms {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionGroupForms;
    /**
     * getGroup :
     * @return String 
     */

    @Override
    public String getGroup() {
        String value = GroupFormsHelper.getGroup(getWikitty());
        return value;
}

    /**
     * setGroup :
     * @param group 
     */

    @Override
    public void setGroup(String group) {
        String oldValue = getGroup();
        GroupFormsHelper.setGroup(getWikitty(), group);
        getPropertyChangeSupport().firePropertyChange(GroupForms.FIELD_GROUPFORMS_GROUP, oldValue, getGroup());
}

    /**
     * getForm :
     * @return Set<String> 
     */

    @Override
    public Set<String> getForm() {
        Set<String> result = GroupFormsHelper.getForm(getWikitty());
        return result;
}

    /**
     * setForm :
     * @param form 
     */

    @Override
    public void setForm(Set<String> form) {
        Set<String> oldValue = getForm();
        GroupFormsHelper.setForm(getWikitty(), form);
        getPropertyChangeSupport().firePropertyChange(GroupForms.FIELD_GROUPFORMS_FORM, oldValue, getForm());
}

    /**
     * addAllForm :
     * @param form 
     */

    @Override
    public void addAllForm(Set<String> form) {
        Set<String> oldValue = getForm();
        GroupFormsHelper.addAllForm(getWikitty(), form);
        getPropertyChangeSupport().firePropertyChange(GroupForms.FIELD_GROUPFORMS_FORM, oldValue, getForm());
}

    /**
     * addForm :
     * @param element 
     */

    @Override
    public void addForm(String element) {
        GroupFormsHelper.addForm(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(GroupForms.FIELD_GROUPFORMS_FORM, null, getForm());
}

    /**
     * removeForm :
     * @param element 
     */

    @Override
    public void removeForm(String element) {
        GroupFormsHelper.removeForm(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(GroupForms.FIELD_GROUPFORMS_FORM, null, getForm());
}

    /**
     * clearForm :
     */

    @Override
    public void clearForm() {
        GroupFormsHelper.clearForm(getWikitty());
        getPropertyChangeSupport().firePropertyChange(GroupForms.FIELD_GROUPFORMS_FORM, null, getForm());
}

    /**
     * GroupFormsAbstract :
     */

    public GroupFormsAbstract() {
        super();
}

    /**
     * GroupFormsAbstract :
     * @param wikitty 
     */

    public GroupFormsAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * GroupFormsAbstract :
     * @param businessEntityImpl 
     */

    public GroupFormsAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionGroupForms =
                new WikittyExtension(EXT_GROUPFORMS,
                                     "1.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "Wikitty group unique=\"true\"", 
                                             "Wikitty form[0-*] unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionGroupForms);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //GroupFormsAbstract
