package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.sharengo.wikitty.BusinessEntityWikitty;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyUtil;

public class ClientImpl extends com.jurismarches.vradi.entities.QueryMakerImpl implements Client, QueryMaker {

    private static final long serialVersionUID = -88940554L;

    static final protected List<WikittyExtension> extensions;
    static final public WikittyExtension extensionClient =
        new WikittyExtension(EXT_CLIENT, "3.0", QueryMaker.EXT_QUERYMAKER,
		    WikittyUtil.buildFieldMapExtension(
				"String name unique",
				"Date creationDate unique",
				"String address unique",
				"String phone unique",
				"String contact unique"));
    static {
        ArrayList<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(QueryMakerImpl.extensions);

        // EC-20100420 add current extension after parent ones
        // if current is loaded before required extension
        // load failed because required extension is missing
        exts.add(extensionClient);

        extensions = Collections.unmodifiableList(exts);
    }

	public ClientImpl() {
		super();
	}

    public ClientImpl(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public ClientImpl(Wikitty wi) {
		super(wi);
	}


    public void setName(String name) {
        getWikitty().setField(EXT_CLIENT, "name", name);
    }

    public String getName() {
        String result = getWikitty().getFieldAsString(EXT_CLIENT, "name");
        return result;
    }


    public void setCreationDate(Date creationDate) {
        getWikitty().setField(EXT_CLIENT, "creationDate", creationDate);
    }

    public Date getCreationDate() {
        Date result = getWikitty().getFieldAsDate(EXT_CLIENT, "creationDate");
        return result;
    }


    public void setAddress(String address) {
        getWikitty().setField(EXT_CLIENT, "address", address);
    }

    public String getAddress() {
        String result = getWikitty().getFieldAsString(EXT_CLIENT, "address");
        return result;
    }


    public void setPhone(String phone) {
        getWikitty().setField(EXT_CLIENT, "phone", phone);
    }

    public String getPhone() {
        String result = getWikitty().getFieldAsString(EXT_CLIENT, "phone");
        return result;
    }


    public void setContact(String contact) {
        getWikitty().setField(EXT_CLIENT, "contact", contact);
    }

    public String getContact() {
        String result = getWikitty().getFieldAsString(EXT_CLIENT, "contact");
        return result;
    }

    public java.util.Set<String> getQueries() {
        java.util.Set<String> result = getWikitty().getFieldAsSet(EXT_QUERYMAKER, "queries", String.class);
        return result;
    }

    public void addQueries(String element) {
        getWikitty().addToField(EXT_QUERYMAKER, "queries", element);
    }
    
    public void removeQueries(String element) {
        getWikitty().removeFromField(EXT_QUERYMAKER, "queries", element);
    }
    
    public void clearQueries() {
        getWikitty().clearField(EXT_QUERYMAKER, "queries");
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }


} //ClientImpl
