/*
 * *##% 
 * Vradi :: Entities
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.entities;

import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.WikittyExtension;

import java.util.LinkedHashMap;

/**
 * @author morin
 *         Date: 4 déc. 2009
 *         Time: 15:16:12
 */
public final class ModificationTag {

    static final public String EXT_MODIFICATION_TAG = "ModificationTag";
    static final public String EXT_VERSION = "1.1";
    static final public String FIELD_LAST_MODIFIED = "lastModified";
    static final public String FQ_FIELD_LAST_MODIFIED = EXT_MODIFICATION_TAG + ".lastModified";
    static final public String FIELD_LAST_MODIFIER = "lastModifier";
    static final public String FQ_FIELD_LAST_MODIFIER = EXT_MODIFICATION_TAG + ".lastModifier";
    static final public WikittyExtension MODIFICATION_TAG = getExtension();

    static final private WikittyExtension getExtension() {
        LinkedHashMap<String, FieldType> fieldMap = new LinkedHashMap<String, FieldType>();
        fieldMap.put(FIELD_LAST_MODIFIED, FieldTypeEnum.DATE_TIME.getFieldType());
        fieldMap.put(FIELD_LAST_MODIFIER, FieldTypeEnum.STRING.getFieldType());
        WikittyExtension ext = new WikittyExtension(EXT_MODIFICATION_TAG, EXT_VERSION, null, fieldMap);
        return ext;
    }
}
