package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.sharengo.wikitty.BusinessEntityWikitty;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyUtil;

public class SendingImpl extends BusinessEntityWikitty implements Sending {

    private static final long serialVersionUID = -258269110L;


    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionSending =
        new WikittyExtension(EXT_SENDING, "1", null,
		    WikittyUtil.buildFieldMapExtension(
				"Date sentDate unique",
				"Date receptionDate unique",
				"Wikitty client unique",
				"Wikitty form unique"));
    static {
        ArrayList<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        exts.add(extensionSending);

        extensions = Collections.unmodifiableList(exts);
    }
 
	public SendingImpl() {
		super();
	}

    public SendingImpl(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public SendingImpl(Wikitty wi) {
		super(wi);
	}


    public void setSentDate(Date sentDate) {
        getWikitty().setField(EXT_SENDING, "sentDate", sentDate);
    }

    public Date getSentDate() {
        Date result = getWikitty().getFieldAsDate(EXT_SENDING, "sentDate");
        return result;
    }


    public void setReceptionDate(Date receptionDate) {
        getWikitty().setField(EXT_SENDING, "receptionDate", receptionDate);
    }

    public Date getReceptionDate() {
        Date result = getWikitty().getFieldAsDate(EXT_SENDING, "receptionDate");
        return result;
    }


    public void setClient(String client) {
        getWikitty().setField(EXT_SENDING, "client", client);
    }

    public String getClient() {
        String result = getWikitty().getFieldAsString(EXT_SENDING, "client");
        return result;
    }


    public void setForm(String form) {
        getWikitty().setField(EXT_SENDING, "form", form);
    }

    public String getForm() {
        String result = getWikitty().getFieldAsString(EXT_SENDING, "form");
        return result;
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }


} //SendingImpl
