<%--
  #%L
  SGQ :: Web
  $Id:$
  $HeadURL:$
  %%
  Copyright (C) 2012 Herboristerie Cailleau
  %%
  Herboristerie Cailleau - Tous droits réservés
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<%@taglib uri="/struts-tags" prefix="s" %>
<%@taglib uri="http://shiro.apache.org/tags" prefix="shiro" %>
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
       <title>Détail d'un lot</title>
    </head>
    <body>
        <h1>Détail d'un lot</h1>

        <h2>Informations</h2>

        <ul>
            <li><strong>Num&eacute;ro de lot</strong> : <s:property value="batch.number" /></li>
            <li><strong>Produit</strong> : <s:property value="batch.product.code" /> - <s:property value="batch.product.name" /></li>
            <li><strong>Nom latin</strong> : <s:property value="batch.product.latinName" /></li>
            <li><strong>Num&eacute;ro de commande interne</strong> : <s:property value="batch.orderNumber" /></li>
            <li><strong>Date d'entr&eacute;e</strong> : <s:text name="sgq.web.common.dateformat">
              <s:param value="batch.entryDate"/>
            </s:text></li>
            <li><strong title="Date de Mise En Service">DMES</strong> : 
                <s:if test="batchModel.dmes == null">
                    <s:if test="batch.expiredDate != null">
                        <em>non connue</em>
                    </s:if>
                    <s:else>
                        <em>pas encore mis en service</em>
                    </s:else>
                </s:if>
                <s:else>
                    <s:text name="sgq.web.common.dateformat">
                      <s:param value="batchModel.dmes"/>
                    </s:text>
                </s:else>
            </li>
            <li><strong title="Date Prévisionnelle de Mise En Service">DPMES</strong> : 
                <s:if test="batch.dpmes != null">
                  <s:text name="sgq.web.common.dateformat">
  	                <s:param value="batch.dpmes"/>
  	              </s:text>
                </s:if>
                <s:else>
                    <em>non renseign&eacute;e</em>
                </s:else>
                <shiro:hasPermission name="batch:write:dpmes">
                (<a href="<s:url action='batch-edit!input' namespace='/user'>
                <s:param name="batchId"><s:property value="batch.topiaId" /></s:param>
                </s:url>">modifier</a>)
                </shiro:hasPermission>
            </li>
            <li><strong title="Date Limite d'Utilisation Optimale">DLUO</strong> :
                <s:text name="sgq.web.common.dateformat">
	              <s:param value="batch.dluo"/>
	            </s:text></li>
            <li><strong title="Date de Mise En Service Détaillant">DMESD</strong> :
                <s:if test="batch.dmesd != null">
                  <s:text name="sgq.web.common.dateformat">
                    <s:param value="batch.dmesd"/>
                  </s:text>
                </s:if>
                <s:elseif test="batch.expiredDate != null">
                    <em>non connue</em>
                </s:elseif>
                <s:else>
                    <em>pas encore exp&eacute;di&eacute;</em>
                </s:else></li>
            <li><strong>Code fournisseur</strong> : <s:property value="batch.supplier.code" /></li>
            <shiro:hasPermission name="batch:read:supplier">
              <li><strong>Fournisseur</strong> : <s:property value="batch.supplier.name" /></li>
            </shiro:hasPermission>
            <li><strong>Code client dédié</strong> :
                <s:if test="batch.dedicatedClient != null">
                    <s:property value="batch.dedicatedClient.code" />
                </s:if>
                <s:else>
                    <em>pas de client d&eacute;di&eacute;</em>
                </s:else>
            </li>
            <shiro:hasPermission name="batch:read:client">
              <li><strong>Client dédié</strong> :
                <s:if test="batch.dedicatedClient != null">
                    <s:property value="batch.dedicatedClient.name" />
                </s:if>
                <s:else>
                    <em>pas de client d&eacute;di&eacute;</em>
                </s:else>
              </li>
            </shiro:hasPermission>
            <li><strong>Origine</strong> : <s:property value="batch.origin.country" /></li>
            <s:if test="batch.sampleCode != null && !batch.sampleCode.empty">
                <li><strong>Num&eacute;ro d'&eacute;chantillon</strong> : <s:property value="batch.sampleCode" /></li>
            </s:if>
            <s:if test="!batch.product.productStatus.empty">
                <li><strong>Statuts</strong> :
                    <ul>
                      <s:iterator value="batch.product.productStatus" status="iteratorStatus">
                        <li><s:property value="name"/></li>
                      </s:iterator>
                    </ul>
                </li>
            </s:if>
            <li><strong>Quantité entrée</strong> :
                <s:property value="@com.herbocailleau.sgq.business.SgqUtils@formatNumber(batch.quantity)" />
                <s:property value="getProductUnit(batch.product)" /></li>
            <li><strong>Quantité restante</strong> :
                <s:property value="@com.herbocailleau.sgq.business.SgqUtils@formatNumber(batchModel.totalPresentation)" />
                <s:property value="getProductUnit(batch.product)" /></li>
            <li><strong>Cumul vente</strong> :
                <s:property value="@com.herbocailleau.sgq.business.SgqUtils@formatNumber(batchModel.totalSale)" />
                <s:property value="getProductUnit(batch.product)" /></li>
            <shiro:hasPermission name="batch:read:comment">
              <li><strong>Commentaire</strong> : <s:if test="batch.comment != null && !batch.comment.empty">
                  <s:property value="batch.comment" />
                </s:if>
                <shiro:hasPermission name="batch:write:comment">
                  (<a href="<s:url action='batch-edit!input' namespace='/user'>
                    <s:param name="batchId"><s:property value="batch.topiaId" /></s:param>
                  </s:url>">modifier</a>)
                </shiro:hasPermission>
              </li>
            </shiro:hasPermission>
            <s:if test="batch.expiredDate != null">
              <li><strong>Lot épuisé</strong> : depuis le <s:text name="sgq.web.common.dateformat">
                    <s:param value="batch.expiredDate"/>
                  </s:text>
              </li>
            </s:if>
        </ul>
        
        <shiro:hasPermission name="batch:read:presentation">
          <h2>Présentations</h2>
          <table class="listing">
            <tr>
                <th>Type</th>
                <th title="Date de Mise En Service Détaillant">DMESD</th>
                <th>Zone</th>
                <th>Emplacement</th>
                <th>Localisation</th>
                <th>Quantit&eacute; restante</th>
            </tr>

            <s:set name="total" value="0" />
            <s:iterator value="presentationModels">

              <s:if test="places.empty">
                <tr>
                    <td title="<s:property value="presentationCode.description" />">
                      <shiro:hasPermission name="batch:write:presentation">
                        <a href="<s:url action='batch-presentation-edit!input' namespace='/user'>
                          <s:param name="presentationId"><s:property value="presentation.topiaId" /></s:param>
                        </s:url>"><s:property value="presentation.presentationCode.code" /></a>
                      </shiro:hasPermission>
                      <shiro:lacksPermission name="batch:write:presentation">
                        <s:property value="presentation.presentationCode.code" />
                      </shiro:lacksPermission>
                    </td>
                    <td><s:if test="presentation.dmesd != null">
                          <shiro:hasPermission name="batch:write:presentation">
                            <a href="<s:url action='batch-presentation-edit!input' namespace='/user'>
                                <s:param name="presentationId"><s:property value="presentation.topiaId" /></s:param>
                            </s:url>"><s:text name="sgq.web.common.dateformat">
                              <s:param value="presentation.dmesd"/>
                            </s:text></a>
                          </shiro:hasPermission>
                          <shiro:lacksPermission name="batch:write:presentation">
                            <s:text name="sgq.web.common.dateformat">
                              <s:param value="presentation.dmesd"/>
                            </s:text>
                          </shiro:lacksPermission>
                        </s:if></td>
                    <td colspan="3"><em>Aucun emplacement déterminé</em></td>
                    <td>
                      <shiro:hasPermission name="batch:write:presentation">
                        <a href="<s:url action='batch-presentation-edit!input' namespace='/user'>
                          <s:param name="presentationId"><s:property value="presentation.topiaId" /></s:param>
                        </s:url>"><s:property value="@com.herbocailleau.sgq.business.SgqUtils@formatNumber(presentation.quantity)" />
                        <s:property value="getProductUnit(presentation.batch.product)" /></a>
                      </shiro:hasPermission>
                      <shiro:lacksPermission name="batch:write:presentation">
                        <s:property value="@com.herbocailleau.sgq.business.SgqUtils@formatNumber(presentation.quantity)" />
                        <s:property value="getProductUnit(presentation.batch.product)" />
                      </shiro:lacksPermission>
                    </td>
                </tr>
              </s:if>
              <s:else>
                <s:iterator value="places" status="placeStatus">
            	<tr>
                    <s:if test="#placeStatus.first">
                      <td title="<s:property value="presentationCode.description" />" rowspan="<s:property value="places.size()" />">
                        <shiro:hasPermission name="batch:write:presentation">
                          <a href="<s:url action='batch-presentation-edit!input' namespace='/user'>
                            <s:param name="presentationId"><s:property value="presentation.topiaId" /></s:param>
                          </s:url>"><s:property value="presentation.presentationCode.code" /></a>
                        </shiro:hasPermission>
                        <shiro:lacksPermission name="batch:write:presentation">
                          <s:property value="presentation.presentationCode.code" />
                        </shiro:lacksPermission>
                      </td>
                      <td rowspan="<s:property value="places.size()" />">
                          <s:if test="presentation.dmesd != null">
                            <shiro:hasPermission name="batch:write:presentation">
                              <a href="<s:url action='batch-presentation-edit!input' namespace='/user'>
                                  <s:param name="presentationId"><s:property value="presentation.topiaId" /></s:param>
                              </s:url>"><s:text name="sgq.web.common.dateformat">
                                <s:param value="presentation.dmesd"/>
                              </s:text></a>
                            </shiro:hasPermission>
                            <shiro:lacksPermission name="batch:write:presentation">
                              <s:text name="sgq.web.common.dateformat">
                                <s:param value="presentation.dmesd"/>
                              </s:text>
                            </shiro:lacksPermission>
                          </s:if></td>
                    </s:if>
                    <td><s:property value="zone.name()" /></td>
                    <td><s:property value="code" /></td>
                    <td><s:property value="name" /></td>
                    <s:if test="#placeStatus.first">
                      <td rowspan="<s:property value="places.size()" />">
                      
                        <s:set name="zcCount" value="0"/>
                        <s:iterator value="places" var="place">
                          <s:if test="#place.getZone() == @com.herbocailleau.sgq.entities.Zone@ZC">
                            <s:set name="zcCount" value="#zcCount + 1"/>
                          </s:if>
                        </s:iterator>
                        <s:if test="places.size() >= 1 && places.size() == #zcCount && presentation.quantity < 0">
                          une quantité du lot a été stockée ou déclarée dans cette zone
                        </s:if>

                        <s:else>
                          <shiro:hasPermission name="batch:write:presentation">
                            <a href="<s:url action='batch-presentation-edit!input' namespace='/user'>
                              <s:param name="presentationId"><s:property value="presentation.topiaId" /></s:param>
                            </s:url>"><s:property value="@com.herbocailleau.sgq.business.SgqUtils@formatNumber(presentation.quantity)" />
                            <s:property value="getProductUnit(presentation.batch.product)" /></a>
                          </shiro:hasPermission>
                          <shiro:lacksPermission name="batch:write:presentation">
                            <s:property value="@com.herbocailleau.sgq.business.SgqUtils@formatNumber(presentation.quantity)" />
                            <s:property value="getProductUnit(presentation.batch.product)" />
                          </shiro:lacksPermission>
                        </s:else>
                      </td>
                    </s:if>
	            </tr>
                </s:iterator>
              </s:else>
              <s:set name="total" value="#total + presentation.quantity" />
            </s:iterator>
            <tr>
                <td class="total" colspan="5">Total :</td>
                <td>
                   <s:property value="@com.herbocailleau.sgq.business.SgqUtils@formatNumber(#total)" />
                   <s:property value="getProductUnit(batch.product)" />
                </td>
            </tr>
          </table>
        </shiro:hasPermission>

        <shiro:hasPermission name="batch:read:analyze">
          <h2>Analyses</h2>
  
          <s:if test="analyzes.empty">
            <p class="noneavailable">Aucune analyse disponible.</p>
          </s:if>
          <s:else>
            <table class="listing analysis">
                <tr>
                    <th>Mention</th>
                    <th>Catégorie</th>
                    <th>Type</th>
                    <th>Prestataire</th>
                    <th>Date d'envoi de l'échantillon</th>
                </tr>
                <s:iterator value="analyzes" var="analyze">
                	<tr>
                        <s:if test='#analyze.synthesisMention == @com.herbocailleau.sgq.entities.SynthesisMention@CONFORM'>
                          <td class="conform">Conforme</td>
                        </s:if>
                        <s:elseif test='#analyze.synthesisMention == @com.herbocailleau.sgq.entities.SynthesisMention@ACCEPTABLE'>
                          <td class="acceptable">Acceptable</td>
                        </s:elseif>
                        <s:elseif test='#analyze.synthesisMention == @com.herbocailleau.sgq.entities.SynthesisMention@NOT_ACCEPTABLE'>
                          <td class="notacceptable">Non acceptable</td>
                        </s:elseif>
                        <s:elseif test="#analyze.sentDate == null">
                          <td class="toSend">&Agrave; faire</td>
                        </s:elseif>
                        <s:elseif test="#analyze.receiptDate == null">
                          <td class="toReceive">Echantillon envoyé le <s:text name="sgq.web.common.dateformat">
                            <s:param value="sentDate"/>
                          </s:text></td>
                        </s:elseif>
                        <s:else>
                          <td>bug</td>
                        </s:else>
                        <shiro:hasPermission name="batch:read:analyzedetails">
                          <td><a href="<s:url action='batch-analyze-view' namespace='/user'>
                             <s:param name="analyzeId"><s:property value="topiaId" /></s:param>
                           </s:url>"><s:property value="analyzeType.analyzeCategory.name" /></a></td>
                          <td><a href="<s:url action='batch-analyze-view' namespace='/user'>
                             <s:param name="analyzeId"><s:property value="topiaId" /></s:param>
                           </s:url>"><s:property value="analyzeType.name" /></a></td>
                        </shiro:hasPermission>
                        <shiro:lacksPermission name="batch:read:analyzedetails">
                          <td><s:property value="analyzeType.analyzeCategory.name" /></td>
                          <td><s:property value="analyzeType.name" /></td>
                        </shiro:lacksPermission>
                      <td><s:property value="supplier.name" /></td>
    	                <td>
                          <s:if test="#analyze.sentDate == null">
                            N/A
                          </s:if>
                          <s:else>
                          <s:text name="sgq.web.common.dateformat">
                            <s:param value="sentDate"/>
                          </s:text>
                          </s:else></td>
    	            </tr>
                </s:iterator>
            </table>
          </s:else>
  
          <shiro:hasPermission name="batch:write:analyze">
            <p><a href="<s:url action='batch-analyze-edit!input' namespace='/user'>
                  <s:param name="batchId"><s:property value="batch.topiaId" /></s:param>
                </s:url>">Préparer une nouvelle analyse pour ce lot</a></p>
          </shiro:hasPermission>
        </shiro:hasPermission>

        <shiro:hasPermission name="batch:read:file">
          <h2>Fichiers</h2>
  
          <s:if test="analyzeFiles.empty">
            <p class="noneavailable">Aucun fichier disponible.</p>
          </s:if>
          <s:else>
            <ul>
              <s:iterator value="analyzeFiles">
                 <li><a href="<s:url action='batch-analyze-download' namespace='/user'>
                    <s:param name="analyzeFileId"><s:property value="topiaId" /></s:param>
                  </s:url>"><s:property value="name" /></a>
                  <shiro:hasPermission name="batch:write:file">
                   (<a href="<s:url action='batch-file-delete' namespace='/user'>
                     <s:param name="analyzeFileId"><s:property value="topiaId" /></s:param>
                    </s:url>" class="sgq-confirm-delete">supprimer</a>)
                  </shiro:hasPermission>
                 </li>
              </s:iterator>
            </ul>
          </s:else>

          <shiro:hasPermission name="batch:write:file">
            <s:form action="batch-analyze-upload" namespace="/user" method="post" enctype="multipart/form-data">
              <s:hidden name="batchId" value="%{batch.topiaId}"/>
              <s:file name="files" key="Nouveau fichier" />
              <s:submit value="Envoyer" />
            </s:form>
          </shiro:hasPermission>
        </shiro:hasPermission>

        <h2>Divers</h2>

        <ul>
            <shiro:hasPermission name="batch:read:control">
              <li><s:if test="batch.product.botanicControl"><a href="<s:url action='batch-control' namespace='/user'>
                  <s:param name="batchId"><s:property value="batch.topiaId" /></s:param>
              </s:url>">Voir le PDF de contr&ocirc;le botanique</a></s:if>
                  <s:elseif test="batch.product.identificationControl"><a href="<s:url action='batch-control' namespace='/user'>
                  <s:param name="batchId"><s:property value="batch.topiaId" /></s:param>
              </s:url>">Voir le PDF de contr&ocirc;le d'identification</a></s:elseif>
              <s:else>
                 <em>Aucun cont&ocirc;le botanique ou d'identification disponible. Merci de contacter l'administrateur pour plus de renseignements.</em>
              </s:else></li>
            </shiro:hasPermission>
            <shiro:hasPermission name="batch:write:expired">
        	  <li><s:if test="batch.expiredDate != null">
                    Lot épuisé depuis le <s:text name="sgq.web.common.dateformat">
                      <s:param value="batch.expiredDate"/>
                    </s:text> (<a href="<s:url action='batch-edit!input' namespace='/user'>
                      <s:param name="batchId"><s:property value="batch.topiaId" /></s:param>
                  </s:url>">modifier</a>)
                  </s:if>
                <s:else>
                  <a href="<s:url action='batch-edit!input' namespace='/user'>
                      <s:param name="batchId"><s:property value="batch.topiaId" /></s:param>
                  </s:url>">Déclarer le lot épuisé</a>
                </s:else>
                </li>
             </shiro:hasPermission>
        </ul>
    </body>
</html>
