/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions;

import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ProductionService;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.Zone;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;
import java.util.Date;
import java.util.List;

public class IndexAction
extends SgqActionSupport
implements Preparable {
    private static final long serialVersionUID = -2484601181596627492L;
    protected BatchService batchService;
    protected ProductionService productionService;
    protected long batchCount;
    protected long operatingBatchCount;
    protected int lastConventionalBatch;
    protected int lastBiologicalBatch;
    protected Date labelProductionImportDate;
    protected Date labelExpeditionImportDate;
    protected List<Batch> batchWithOutputAndPendingAnalysis;
    protected List<Batch> batchWithMoreSellThanStock;
    protected List<Batch> batchWithLabelAfterExpiration;
    protected List<Batch> dedicatedClientExpiredBatch;
    protected List<Batch> batchWithNoStock;
    protected List<Batch> batchWithBulletinToAsk;
    protected Long labelErrorCount;
    protected Date now;
    protected Date batchMaxEntryDate;

    public void prepare() throws Exception {
        this.batchService = (BatchService)this.newService(BatchService.class);
        this.productionService = (ProductionService)this.newService(ProductionService.class);
    }

    public String execute() throws Exception {
        this.batchCount = this.batchService.getBatchCount();
        this.operatingBatchCount = this.batchService.getOperatingBatchCount();
        this.lastConventionalBatch = this.batchService.getLastConventionalBatch();
        this.lastBiologicalBatch = this.batchService.getLastBiologicalBatch();
        this.labelProductionImportDate = this.productionService.getLastImportDate(Zone.ZE);
        this.labelExpeditionImportDate = this.productionService.getLastImportDate(Zone.ZP);
        return "success";
    }

    public long getBatchCount() {
        return this.batchCount;
    }

    public long getOperatingBatchCount() {
        return this.operatingBatchCount;
    }

    public int getLastConventionalBatch() {
        return this.lastConventionalBatch;
    }

    public int getLastBiologicalBatch() {
        return this.lastBiologicalBatch;
    }

    public Date getLabelProductionImportDate() {
        return this.labelProductionImportDate;
    }

    public Date getLabelExpeditionImportDate() {
        return this.labelExpeditionImportDate;
    }

    public List<Batch> getBatchWithOutputAndPendingAnalysis() {
        if (this.batchWithOutputAndPendingAnalysis == null) {
            this.batchWithOutputAndPendingAnalysis = this.batchService.getBatchWithOutputAndPendingAnalysis();
        }
        return this.batchWithOutputAndPendingAnalysis;
    }

    public long getLabelErrorCount() {
        if (this.labelErrorCount == null) {
            this.labelErrorCount = this.productionService.getLabelErrorCount();
        }
        return this.labelErrorCount;
    }

    public List<Batch> getBatchWithMoreSellThanStock() {
        if (this.batchWithMoreSellThanStock == null) {
            this.batchWithMoreSellThanStock = this.batchService.getBatchWithMoreSellThanStock();
        }
        return this.batchWithMoreSellThanStock;
    }

    public List<Batch> getDedicatedClientExpiredBatch() {
        if (this.dedicatedClientExpiredBatch == null) {
            this.dedicatedClientExpiredBatch = this.batchService.getDedicatedClientExpiredBatch();
        }
        return this.dedicatedClientExpiredBatch;
    }

    public List<Batch> getBatchWithNoStock() {
        if (this.batchWithNoStock == null) {
            this.batchWithNoStock = this.batchService.getBatchWithNoStock();
        }
        return this.batchWithNoStock;
    }

    public List<Batch> getBatchWithLabelAfterExpiration() {
        if (this.batchWithLabelAfterExpiration == null) {
            this.batchWithLabelAfterExpiration = this.productionService.getBatchWithLabelAfterExpiration();
        }
        return this.batchWithLabelAfterExpiration;
    }

    public List<Batch> getBatchWithBulletinToAsk() {
        if (this.batchWithBulletinToAsk == null) {
            this.batchWithBulletinToAsk = this.batchService.getBatchWithBulletinToAsk();
        }
        return this.batchWithBulletinToAsk;
    }

    public Date getNow() {
        if (this.now == null) {
            this.now = new Date();
        }
        return this.now;
    }

    public Date getBatchMaxEntryDate() {
        if (this.batchMaxEntryDate == null) {
            this.batchMaxEntryDate = this.batchService.getBatchMaxEntryDate();
        }
        return this.batchMaxEntryDate;
    }

    public long daysBetween(Date date1, Date date2) {
        return SgqUtils.daysBetween((Date)date1, (Date)date2);
    }
}

