/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.user;

import com.herbocailleau.sgq.business.model.PresentationModel;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Place;
import com.herbocailleau.sgq.entities.Zone;
import com.herbocailleau.sgq.web.SgqActionSupport;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PlaceAction
extends SgqActionSupport {
    private static final long serialVersionUID = 1L;
    protected ReferentialService referentialService;
    protected List<Zone> zones;
    protected List<Place> places;
    protected Zone zone;
    protected Place place;
    protected String placeId;
    protected String product;
    protected Map<Place, List<PresentationModel>> batchPresentations;

    public Zone getZone() {
        return this.zone;
    }

    public void setZone(Zone zone) {
        this.zone = zone;
    }

    public void setPlaceId(String placeId) {
        this.placeId = placeId;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public String execute() throws Exception {
        this.zones = Arrays.asList(Zone.values());
        this.referentialService = (ReferentialService)this.newService(ReferentialService.class);
        this.places = this.referentialService.getPlaces(this.zone);
        if (StringUtils.isNotEmpty((CharSequence)this.placeId)) {
            this.place = this.referentialService.getPlaceById(this.placeId);
            if (this.zone != null && this.place.getZone() != this.zone) {
                this.place = null;
            }
        }
        BatchService batchService = (BatchService)this.newService(BatchService.class);
        if (this.place != null || StringUtils.isNotBlank((CharSequence)this.product)) {
            this.batchPresentations = batchService.findAllBatchPerPlacesAndProduct(this.zone, this.place, this.product);
        }
        return "success";
    }

    public List<Zone> getZones() {
        return this.zones;
    }

    public List<Place> getPlaces() {
        return this.places;
    }

    public Place getPlace() {
        return this.place;
    }

    public Map<Place, List<PresentationModel>> getBatchPresentations() {
        return this.batchPresentations;
    }
}

