/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.user;

import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.business.model.AnalyzeFilter;
import com.herbocailleau.sgq.business.model.AnalyzeModel;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.BatchAnalyze;
import com.herbocailleau.sgq.entities.Supplier;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.nuiton.i18n.I18n;

public class AnalyzeDashboardAction
extends SgqActionSupport
implements Preparable {
    private static final long serialVersionUID = 3074255662512738956L;
    protected ReferentialService referentialService;
    protected BatchService batchService;
    protected List<AnalyzeModel> analysisToSend;
    protected List<BatchAnalyze> analysisToReceive;
    protected String analyzeTypeId;
    protected String supplier;
    protected String sentDateBegin;
    protected String sentDateEnd;
    protected int batchNumberBegin;
    protected int batchNumberEnd;
    protected AnalyzeType analyzeType;
    protected List<AnalyzeType> analyzeTypes;
    protected List<Supplier> suppliers;
    protected List<String> analyzeIds;

    public void setAnalyzeTypeId(String analyzeTypeId) {
        this.analyzeTypeId = analyzeTypeId;
    }

    public String getSupplier() {
        return this.supplier;
    }

    public void setSupplier(String supplier) {
        this.supplier = supplier;
    }

    public String getSentDateBegin() {
        return this.sentDateBegin;
    }

    public void setSentDateBegin(String sentDateBegin) {
        this.sentDateBegin = sentDateBegin;
    }

    public String getSentDateEnd() {
        return this.sentDateEnd;
    }

    public void setSentDateEnd(String sentDateEnd) {
        this.sentDateEnd = sentDateEnd;
    }

    public int getBatchNumberBegin() {
        return this.batchNumberBegin;
    }

    public void setBatchNumberBegin(int batchNumberBegin) {
        this.batchNumberBegin = batchNumberBegin;
    }

    public int getBatchNumberEnd() {
        return this.batchNumberEnd;
    }

    public void setBatchNumberEnd(int batchNumberEnd) {
        this.batchNumberEnd = batchNumberEnd;
    }

    public void prepare() throws Exception {
        this.referentialService = (ReferentialService)this.newService(ReferentialService.class);
        this.batchService = (BatchService)this.newService(BatchService.class);
    }

    protected void loadData() {
        this.analyzeTypes = this.referentialService.findAllAnalyzeTypes();
        this.suppliers = this.referentialService.getAllSupplierOnlyLabs();
        if (StringUtils.isNotEmpty((CharSequence)this.analyzeTypeId)) {
            this.analyzeType = this.referentialService.findAnalyzeTypeById(this.analyzeTypeId);
        }
        AnalyzeFilter filter = new AnalyzeFilter();
        filter.setAnalyzeType(this.analyzeType);
        filter.setBatchNumberBegin(this.batchNumberBegin);
        filter.setBatchNumberEnd(this.batchNumberEnd);
        if (StringUtils.isNotBlank((CharSequence)this.sentDateBegin)) {
            try {
                filter.setSentDateBegin(SgqUtils.parseSgqDate((String)this.sentDateBegin));
            }
            catch (ParseException ex) {
                this.addActionError("Date invalide (dd/mm/yyyy) : " + this.sentDateBegin);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.sentDateEnd)) {
            try {
                filter.setSentDateEnd(SgqUtils.parseSgqDate((String)this.sentDateEnd));
            }
            catch (ParseException ex) {
                this.addActionError("Date invalide (dd/mm/yyyy) : " + this.sentDateEnd);
            }
        }
        filter.setSupplier(this.supplier);
        BatchService batchService = (BatchService)this.newService(BatchService.class);
        this.analysisToSend = batchService.getAnalysisToSend(filter);
        this.analysisToReceive = batchService.getAnalysisToReceive(filter);
    }

    public String input() throws Exception {
        this.loadData();
        return super.input();
    }

    public AnalyzeType getAnalyzeType() {
        return this.analyzeType;
    }

    public List<AnalyzeType> getAnalyzeTypes() {
        return this.analyzeTypes;
    }

    public List<Supplier> getSuppliers() {
        return this.suppliers;
    }

    public List<AnalyzeModel> getAnalysisToSend() {
        return this.analysisToSend;
    }

    public List<BatchAnalyze> getAnalysisToReceive() {
        return this.analysisToReceive;
    }

    public Date getNow() {
        return new Date();
    }

    public void setAnalyzeIds(List<String> analyzeIds) {
        this.analyzeIds = analyzeIds;
    }

    public void validate() {
        if (this.analyzeIds != null) {
            for (String analyzeId : this.analyzeIds) {
                BatchAnalyze analyze = this.batchService.getAnalyzeById(analyzeId);
                String check = this.getParameter("check." + analyze.getTopiaId());
                if (!"true".equalsIgnoreCase(check)) continue;
                String supplierId = this.getParameter("supplier." + analyze.getTopiaId());
                Supplier supplier = this.referentialService.getSupplierById(supplierId);
                if (supplier == null) {
                    this.addActionError(I18n._((String)"Prestataire manquant pour l'analyse %s du lot %d", (Object[])new Object[]{analyze.getAnalyzeType().getName(), analyze.getBatch().getNumber()}));
                }
                String sentDate = this.getParameter("sentDate." + analyze.getTopiaId());
                Date sent = null;
                try {
                    sent = SgqUtils.parseSgqDate((String)sentDate);
                }
                catch (ParseException ex) {
                    this.addActionError(I18n._((String)"Date d'envoi invalide pour l'analyse %s du lot %d", (Object[])new Object[]{analyze.getAnalyzeType().getName(), analyze.getBatch().getNumber()}));
                }
                String receiveDate = this.getParameter("receiveDate." + analyze.getTopiaId());
                try {
                    Date receive = SgqUtils.parseSgqDate((String)receiveDate);
                    if (sent == null || !receive.before(sent)) continue;
                    this.addActionError(I18n._((String)"La date de r\u00e9ception doit \u00eatre post\u00e9rieure \u00e0 la date d'envoi pour le lot %d", (Object[])new Object[]{analyze.getBatch().getNumber()}));
                }
                catch (ParseException ex) {
                    this.addActionError(I18n._((String)"Date de r\u00e9ception invalide pour l'analyse %s du lot %d", (Object[])new Object[]{analyze.getAnalyzeType().getName(), analyze.getBatch().getNumber()}));
                }
            }
        }
        if (this.hasErrors()) {
            this.loadData();
        }
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "analyze-dashboard"})})
    public String execute() throws Exception {
        String result = "success";
        if (this.analyzeIds != null) {
            for (String analyzeId : this.analyzeIds) {
                BatchAnalyze analyze = this.batchService.getAnalyzeById(analyzeId);
                String supplierId = this.getParameter("supplier." + analyze.getTopiaId());
                Supplier supplier = this.referentialService.getSupplierById(supplierId);
                Date sentDate = null;
                Date receiveDate = null;
                String check = this.getParameter("check." + analyze.getTopiaId());
                if ("true".equalsIgnoreCase(check)) {
                    String sDate = this.getParameter("sentDate." + analyze.getTopiaId());
                    String rDate = this.getParameter("receiveDate." + analyze.getTopiaId());
                    sentDate = SgqUtils.parseSgqDate((String)sDate);
                    receiveDate = SgqUtils.parseSgqDate((String)rDate);
                }
                this.batchService.sendAnalyzeToSupplier(analyze, sentDate, receiveDate, supplier);
            }
        } else {
            result = this.input();
        }
        return result;
    }
}

