/*
 * #%L
 * SGQ :: Business
 * $Id: ExpeditionDAOImpl.java 113 2012-10-02 14:38:07Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1/sgq-business/src/main/java/com/herbocailleau/sgq/entities/ExpeditionDAOImpl.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.entities;

import java.util.Date;
import java.util.List;

import org.nuiton.topia.TopiaException;

public class ExpeditionDAOImpl<E extends Expedition> extends ExpeditionDAOAbstract<E> {

    /**
     * Trouve parmis les expedition la date de la derniere expedition
     * effectuer par la zone sources specifiée.
     * 
     * @param zone zone source
     * @return date or {@code null}
     * @throws TopiaException 
     */
    public Date findMaxDateForZone(Zone zone) throws TopiaException {
        String query = "select max(date) from " + Expedition.class.getName() +
                " where " + Expedition.PROPERTY_SOURCE + " = :zone";
        
        Date result = (Date)context.findUnique(query, "zone", zone);
        return result;
    }

    /**
     * Trouve une vente effectuée pour une presentation DEPUIS une zone.
     * Il peut y en avoir d'autre, mais retourne la première.
     * 
     * @param presentation presentation
     * @param zone zone
     * @return une expedition au hazard
     * @throws TopiaException 
     */
    public Expedition findSingleForPresentationAndZone(Presentation presentation, Zone zone) throws TopiaException {
        String query = "from " + Expedition.class.getName() +
                " where presentation = :presentation" +
                " and " + Expedition.PROPERTY_SOURCE + " = :zone";

        // on ne peut pas utiliser findUnique qui lance une exception en cas
        // de resultat multiples, ce qui arrive inevitablement
        List<Expedition> results = context.find(query, 0, 1, "presentation", presentation,
                "zone", zone);
        Expedition result = null;
        if (!results.isEmpty()) {
            result = results.get(0);
        }
        return result;
    }

} //ExpeditionDAOImpl<E extends Expedition>
