/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.business.model;

import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.business.model.BatchModel;
import com.herbocailleau.sgq.business.model.BatchModelFunction;
import com.herbocailleau.sgq.business.model.SearchModel;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.BatchAnalyze;
import com.herbocailleau.sgq.entities.SynthesisMention;
import org.apache.commons.collections.CollectionUtils;
import org.nuiton.i18n.I18n;

public enum SearchColumn {
    PRODUCT_CODE(I18n._((String)"Code Produit", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(SearchModel searchModel, BatchModel batchModel) {
            return batchModel.getBatch().getProduct().getCode();
        }
    }, "search:column:common", true),
    PRODUCT_NAME(I18n._((String)"Nom Produit", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(SearchModel searchModel, BatchModel batchModel) {
            return batchModel.getBatch().getProduct().getName();
        }
    }, "search:column:common", true),
    PRODUCT_LATIN_NAME(I18n._((String)"Nom latin", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(SearchModel searchModel, BatchModel batchModel) {
            return batchModel.getBatch().getProduct().getLatinName();
        }
    }, "search:column:common", false),
    PRODUCT_CATEGORY(I18n._((String)"Cat\u00e9gorie", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(SearchModel searchModel, BatchModel batchModel) {
            return batchModel.getBatch().getProduct().getCategory();
        }
    }, "search:column:common", false),
    BATCH_NUMBER(I18n._((String)"Lot", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(SearchModel searchModel, BatchModel batchModel) {
            return String.valueOf(batchModel.getBatch().getNumber());
        }
    }, "search:column:common", true),
    BATCH_SUPPLIER(I18n._((String)"Fournisseur", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(SearchModel searchModel, BatchModel batchModel) {
            String result = null;
            if (batchModel.getBatch().getSupplier() != null) {
                result = batchModel.getBatch().getSupplier().getName();
            }
            return result;
        }
    }, "search:column:supplier", false),
    BATCH_CLIENT(I18n._((String)"Client", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(SearchModel searchModel, BatchModel batchModel) {
            String result = null;
            if (batchModel.getBatch().getDedicatedClient() != null) {
                result = batchModel.getBatch().getDedicatedClient().getName();
            }
            return result;
        }
    }, "search:column:client", false),
    BATCH_ORIGIN(I18n._((String)"Origine", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(SearchModel searchModel, BatchModel batchModel) {
            String result = null;
            if (batchModel.getBatch().getOrigin() != null) {
                result = batchModel.getBatch().getOrigin().getCountry();
            }
            return result;
        }
    }, "search:column:common", false),
    BATCH_TOTAL_PRESENTATION(I18n._((String)"Quantit\u00e9 disponible", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(SearchModel searchModel, BatchModel batchModel) {
            return SgqUtils.formatNumber(batchModel.getTotalPresentation());
        }
    }, "search:column:common", true),
    BATCH_TOTAL_SALE(I18n._((String)"Cumul vente", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(SearchModel searchModel, BatchModel batchModel) {
            return SgqUtils.formatNumber(batchModel.getTotalSale());
        }
    }, "search:column:common", false),
    BATCH_ENTRY_DATE(I18n._((String)"Date d'entr\u00e9e", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(SearchModel searchModel, BatchModel batchModel) {
            String result = null;
            if (batchModel.getBatch().getEntryDate() != null) {
                result = SgqUtils.formatSgqDate(batchModel.getBatch().getEntryDate());
            }
            return result;
        }
    }, "search:column:common", false),
    BATCH_DPMES(I18n._((String)"DPMES", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(SearchModel searchModel, BatchModel batchModel) {
            String result = null;
            if (batchModel.getBatch().getDpmes() != null) {
                result = SgqUtils.formatSgqDate(batchModel.getBatch().getDpmes());
            }
            return result;
        }
    }, "search:column:common", false),
    BATCHDMES(I18n._((String)"DMES", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(SearchModel searchModel, BatchModel batchModel) {
            String result = null;
            if (batchModel.getDmes() != null) {
                result = SgqUtils.formatSgqDate(batchModel.getDmes());
            }
            return result;
        }
    }, "search:column:common", false),
    BATCH_DMESD(I18n._((String)"DMESD", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(SearchModel searchModel, BatchModel batchModel) {
            String result = null;
            if (batchModel.getBatch().getDmesd() != null) {
                result = SgqUtils.formatSgqDate(batchModel.getBatch().getDmesd());
            }
            return result;
        }
    }, "search:column:common", false),
    BATCH_DLUO(I18n._((String)"DLUO", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(SearchModel searchModel, BatchModel batchModel) {
            String result = null;
            if (batchModel.getBatch().getDluo() != null) {
                result = SgqUtils.formatSgqDate(batchModel.getBatch().getDluo());
            }
            return result;
        }
    }, "search:column:common", true),
    ANALYZE_CONFORMITY(I18n._((String)"Conformit\u00e9 Analyse", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(SearchModel searchModel, BatchModel batchModel) {
            StringBuilder strResult = new StringBuilder();
            String separator = "";
            for (BatchAnalyze batchAnalyze : batchModel.getBatchAnalyzes()) {
                AnalyzeType type = batchAnalyze.getAnalyzeType();
                if (!CollectionUtils.isEmpty(searchModel.getAnalyzeTypes()) && !searchModel.getAnalyzeTypes().contains(type) || searchModel.getSynthesisMention() != null && searchModel.getSynthesisMention() != batchAnalyze.getSynthesisMention()) continue;
                strResult.append(separator);
                strResult.append(type.getAnalyzeCategory().getName());
                strResult.append(" - ").append(type.getName());
                strResult.append(" : ").append(this.getCurrentResult(batchAnalyze));
                separator = ", ";
            }
            return strResult.toString();
        }

        protected int compare(BatchAnalyze o1, BatchAnalyze o2) {
            int result = 0;
            if (o1 == null) {
                if (o2 != null) {
                    result = -1;
                }
            } else if (o2 == null) {
                result = 1;
            } else if (o1.getSynthesisMention() != null) {
                result = o2.getSynthesisMention() != null ? o2.getSynthesisMention().ordinal() - o1.getSynthesisMention().ordinal() : 1;
            } else if (o2.getSynthesisMention() != null) {
                result = -1;
            } else if (o1.getSentDate() != null) {
                if (o2.getSentDate() != null) {
                    result = 1;
                }
            } else if (o2.getSentDate() != null) {
                result = -1;
            }
            return result;
        }

        protected String getCurrentResult(BatchAnalyze batchAnalyze) {
            String result = null;
            result = SynthesisMention.CONFORM == batchAnalyze.getSynthesisMention() ? "Conforme" : (SynthesisMention.ACCEPTABLE == batchAnalyze.getSynthesisMention() ? "Acceptable" : (SynthesisMention.NOT_ACCEPTABLE == batchAnalyze.getSynthesisMention() ? "Non acceptable" : (batchAnalyze.getSentDate() != null ? "\u00c9chantillon envoy\u00e9" : "\u00c0 faire")));
            return result;
        }
    }, "search:column:common", false),
    BATCH_EXPIRED_DATE(I18n._((String)"Date d'\u00e9puisement", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(SearchModel searchModel, BatchModel batchModel) {
            String result = null;
            if (batchModel.getBatch().getExpiredDate() != null) {
                result = SgqUtils.formatSgqDate(batchModel.getBatch().getExpiredDate());
            }
            return result;
        }
    }, "search:column:common", false),
    BATCH_COMMENT(I18n._((String)"Commentaire", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(SearchModel searchModel, BatchModel batchModel) {
            String result = batchModel.getBatch().getComment();
            return result;
        }
    }, "search:column:comment", false);

    protected String description;
    protected boolean defaultSelected;
    protected BatchModelFunction function;
    protected String permission;

    private SearchColumn(String description, BatchModelFunction function, String permission, boolean defaultSelected) {
        this.description = description;
        this.function = function;
        this.permission = permission;
        this.defaultSelected = defaultSelected;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isDefaultSelected() {
        return this.defaultSelected;
    }

    public String getPermission() {
        return this.permission;
    }

    public String getValueFor(SearchModel searchModel, BatchModel batchModel) {
        return this.function.apply(searchModel, batchModel);
    }
}

