package com.herbocailleau.sgq.entities;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class ProductionAbstract extends TopiaEntityAbstract implements Production {

    /**
     * Nom de l'attribut en BD : date
     */
    protected Date date;

    /**
     * Nom de l'attribut en BD : quantity
     */
    protected double quantity;

    /**
     * Nom de l'attribut en BD : presentation
     */
    protected Presentation presentation;

    /**
     * Nom de l'attribut en BD : destination
     */
    protected Zone destination;

    /**
     * Nom de l'attribut en BD : source
     */
    protected Zone source;

    private static final long serialVersionUID = 7148681982299418680L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_DATE, Date.class, date);
        visitor.visit(this, PROPERTY_QUANTITY, double.class, quantity);
        visitor.visit(this, PROPERTY_PRESENTATION, Presentation.class, presentation);
        visitor.visit(this, PROPERTY_DESTINATION, Zone.class, destination);
        visitor.visit(this, PROPERTY_SOURCE, Zone.class, source);
        visitor.end(this);
    }

    @Override
    public void setDate(Date date) {
        Date oldValue = this.date;
        fireOnPreWrite(PROPERTY_DATE, oldValue, date);
        this.date = date;
        fireOnPostWrite(PROPERTY_DATE, oldValue, date);
    }

    @Override
    public Date getDate() {
        fireOnPreRead(PROPERTY_DATE, date);
        Date result = this.date;
        fireOnPostRead(PROPERTY_DATE, date);
        return result;
    }

    @Override
    public void setQuantity(double quantity) {
        double oldValue = this.quantity;
        fireOnPreWrite(PROPERTY_QUANTITY, oldValue, quantity);
        this.quantity = quantity;
        fireOnPostWrite(PROPERTY_QUANTITY, oldValue, quantity);
    }

    @Override
    public double getQuantity() {
        fireOnPreRead(PROPERTY_QUANTITY, quantity);
        double result = this.quantity;
        fireOnPostRead(PROPERTY_QUANTITY, quantity);
        return result;
    }

    @Override
    public void setPresentation(Presentation presentation) {
        Presentation oldValue = this.presentation;
        fireOnPreWrite(PROPERTY_PRESENTATION, oldValue, presentation);
        this.presentation = presentation;
        fireOnPostWrite(PROPERTY_PRESENTATION, oldValue, presentation);
    }

    @Override
    public Presentation getPresentation() {
        fireOnPreRead(PROPERTY_PRESENTATION, presentation);
        Presentation result = this.presentation;
        fireOnPostRead(PROPERTY_PRESENTATION, presentation);
        return result;
    }

    @Override
    public void setDestination(Zone destination) {
        Zone oldValue = this.destination;
        fireOnPreWrite(PROPERTY_DESTINATION, oldValue, destination);
        this.destination = destination;
        fireOnPostWrite(PROPERTY_DESTINATION, oldValue, destination);
    }

    @Override
    public Zone getDestination() {
        fireOnPreRead(PROPERTY_DESTINATION, destination);
        Zone result = this.destination;
        fireOnPostRead(PROPERTY_DESTINATION, destination);
        return result;
    }

    @Override
    public void setSource(Zone source) {
        Zone oldValue = this.source;
        fireOnPreWrite(PROPERTY_SOURCE, oldValue, source);
        this.source = source;
        fireOnPostWrite(PROPERTY_SOURCE, oldValue, source);
    }

    @Override
    public Zone getSource() {
        fireOnPreRead(PROPERTY_SOURCE, source);
        Zone result = this.source;
        fireOnPostRead(PROPERTY_SOURCE, source);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

} //ProductionAbstract
