/*
 * #%L
 * SGQ :: Business
 * $Id: Country.java 107 2012-10-01 14:26:37Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.4/sgq-business/src/main/java/com/herbocailleau/sgq/entities/Country.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.entities;

import java.io.Serializable;

/**
 * Enumeration des codes Pays.
 * 
 * @author echatellier
 */
public enum Country implements Serializable {
    AF("AFGHANISTAN", false),
    ZA("AFRIQUE DU SUD", false),
    AX("\u00C5LAND, \u00CELES", false),
    AL("ALBANIE", false),
    DZ("ALGERIE", false),
    DE("ALLEMAGNE", true),
    AD("ANDORRE", false),
    AO("ANGOLA", false),
    AI("ANGUILLA", false),
    AQ("ANTARCTIQUE", false),
    AG("ANTIGUA ET BARBUDA", false),
    SA("ARABIE SAOUDITE", false),
    AR("ARGENTINE", false),
    AM("ARMENIE", false),
    AW("ARUBA", false),
    AU("AUSTRALIE", false),
    AT("AUTRICHE", true),
    AZ("AZERBAIDJAN", false),
    BS("BAHAMAS", false),
    BH("BAHREIN", false),
    BD("BANGLADESH", false),
    BB("BARBADE", false),
    BY("BELARUS", false),
    BE("BELGIQUE", true),
    BZ("BELIZE", false),
    BJ("BENIN", false),
    BM("BERMUDES", false),
    BT("BHOUTAN", false),
    BO("BOLIVIE, l'ETAT PLURINATIONAL DE", false),
    BQ("BONAIRE, SAINT-EUSTACHE ET SABA", false),
    BA("BOSNIE-HERZEGOVINE", false),
    BW("BOTSWANA", false),
    BV("BOUVET, ILE", false),
    BR("BRESIL", false),
    BN("BRUNEI DARUSSALAM", false),
    BG("BULGARIE", true),
    BF("BURKINA FASO", false),
    BI("BURUNDI", false),
    KY("CAIMANES, ILES", false),
    KH("CAMBODGE", false),
    CM("CAMEROUN", false),
    CA("CANADA", false),
    CV("CAP-VERT", false),
    CF("CENTRAFRICAINE, REPUBLIQUE", false),
    CL("CHILI", false),
    CN("CHINE", false),
    CX("CHRISTMAS, ILE", false),
    CY("CHYPRE", true),
    CC("COCOS (KEELING), ILES", false),
    CO("COLOMBIE", false),
    KM("COMORES", false),
    CG("CONGO", false),
    CD("CONGO, LA REPUBLIQUE DEMOCRATIQUE DU (ZAIRE)", false),
    CK("COOK, ILES", false),
    KR("COREE, REPUBLIQUE DE", false),
    KP("COREE, REPUBLIQUE POPULAIRE DEMOCRATIQUE DE", false),
    CR("COSTA RICA", false),
    CI("COTE D'IVOIRE", false),
    HR("CROATIE", false),
    CU("CUBA", false),
    CW("CURACAO", false),
    DK("DANEMARK", true),
    DJ("DJIBOUTI", false),
    DO("DOMINICAINE, REPUBLIQUE", false),
    DM("DOMINIQUE", false),
    EG("EGYPTE", false),
    SV("EL SALVADOR", false),
    AE("EMIRATS ARABES UNIS", false),
    EC("EQUATEUR", false),
    ER("ERYTHREE", false),
    ES("ESPAGNE", true),
    EE("ESTONIE", true),
    US("ETATS-UNIS", false),
    ET("ETHIOPIE", false),
    FK("FALKLAND, ILES (MALVINAS)", false),
    FO("FEROE, ILES", false),
    FJ("FIDJI", false),
    FI("FINLANDE", true),
    FR("FRANCE", true),
    GA("GABON", false),
    GM("GAMBIE", false),
    GE("GEORGIE", false),
    GS("GEORGIE DU SUD ET LES ILES SANDWICH DU SUD", false),
    GH("GHANA", false),
    GI("GIBRALTAR", false),
    GR("GRECE", true),
    GD("GRENADE", false),
    GL("GROENLAND", false),
    GP("GUADELOUPE", false),
    GU("GUAM", false),
    GT("GUATEMALA", false),
    GG("GUERNESEY", false),
    GN("GUINEE", false),
    GW("GUINEE-BISSAU", false),
    GQ("GUINEE EQUATORIALE", false),
    GY("GUYANA", false),
    GF("GUYANE FRANCAISE", false),
    HT("HAITI", false),
    HM("HEARD, ILE ET MCDONALD, ILES", false),
    HN("HONDURAS", false),
    HK("HONG KONG", false),
    HU("HONGRIE", true),
    IM("ILE DE MAN", false),
    UM("ILES MINEURES ELOIGNEES DES ETATS-UNIS", false),
    VG("ILES VIERGES BRITANNIQUES", false),
    VI("ILES VIERGES DES ETATS-UNIS", false),
    IC("INCONNU", false),
    IN("INDE", false),
    ID("INDONESIE", false),
    IR("IRAN, REPUBLIQUE ISLAMIQUE D'", false),
    IQ("IRAQ", false),
    IE("IRLANDE", true),
    IS("ISLANDE", false),
    IL("ISRAEL", false),
    IT("ITALIE", true),
    JM("JAMAIQUE", false),
    JP("JAPON", false),
    JE("JERSEY", false),
    JO("JORDANIE", false),
    KZ("KAZAKHSTAN", false),
    KE("KENYA", false),
    KG("KIRGHIZISTAN", false),
    KI("KIRIBATI", false),
    KW("KOWEIT", false),
    RE("LA REUNION", false),
    LA("LAO, REPUBLIQUE DEMOCRATIQUE POPULAIRE", false),
    LS("LESOTHO", false),
    LV("LETTONIE", true),
    LB("LIBAN", false),
    LR("LIBERIA", false),
    LY("LIBYENNE, JAMAHIRIYA ARABE", false),
    LI("LIECHTENSTEIN", false),
    LT("LITUANIE", true),
    LU("LUXEMBOURG", true),
    MO("MACAO", false),
    MK("MACEDOINE, L'EX-REPUBLIQUE YOUGOSLAVE DE", false),
    MG("MADAGASCAR", false),
    MY("MALAISIE", false),
    MW("MALAWI", false),
    MV("MALDIVES", false),
    ML("MALI", false),
    MT("MALTE", true),
    MP("MARIANNES DU NORD, ILES", false),
    MA("MAROC", false),
    MH("MARSHALL, ILES", false),
    MQ("MARTINIQUE", false),
    MU("MAURICE", false),
    MR("MAURITANIE", false),
    YT("MAYOTTE", false),
    MB("MELANGE EUROPE", true),
    MX("MEXIQUE", false),
    FM("MICRONESIE, ETATS FEDERES DE", false),
    MD("MOLDOVA, REPUBLIQUE DE", false),
    MC("MONACO", false),
    MN("MONGOLIE", false),
    ME("MONTENEGRO", false),
    MS("MONTSERRAT", false),
    MZ("MOZAMBIQUE", false),
    MM("MYANMAR", false),
    NA("NAMIBIE", false),
    NR("NAURU", false),
    NP("NEPAL", false),
    NI("NICARAGUA", false),
    NE("NIGER", false),
    NG("NIGERIA", false),
    NU("NIUE", false),
    NF("NORFOLK, ILE", false),
    NO("NORVEGE", false),
    NC("NOUVELLE-CALEDONIE", false),
    NZ("NOUVELLE-ZELANDE", false),
    IO("OCEAN INDIEN, TERRITOIRE BRITANNIQUE DE L'", false),
    OM("OMAN", false),
    UG("OUGANDA", false),
    UZ("OUZBEKISTAN", false),
    PK("PAKISTAN", false),
    PW("PALAOS", false),
    PS("PALESTINIEN OCCUPE, TERRITOIRE", false),
    PA("PANAMA", false),
    PG("PAPOUASIE-NOUVELLE-GUINEE", false),
    PY("PARAGUAY", false),
    NL("PAYS-BAS", true),
    PE("PEROU", false),
    PH("PHILIPPINES", false),
    PN("PITCAIRN", false),
    PL("POLOGNE", true),
    PF("POLYNESIE FRANCAISE", false),
    PR("PORTO RICO", false),
    PT("PORTUGAL", true),
    QA("QATAR", false),
    RO("ROUMANIE", true),
    GB("ROYAUME-UNI", true),
    RU("RUSSIE, FEDERATION DE", false),
    RW("RWANDA", false),
    EH("SAHARA OCCIDENTAL", false),
    BL("SAINT-BARTHELEMY", false),
    SH("SAINTE-HELENE, ASCENSION ET TRISTAN DA CUNHA", false),
    LC("SAINTE-LUCIE", false),
    KN("SAINT-KITTS-ET-NEVIS", false),
    SM("SAINT-MARIN", false),
    MF("SAINT-MARTIN (PARTIE FRANCAISE)", false),
    SX("SAINT-MARTIN (PARTIE NEERLANDAISE)", false),
    PM("SAINT-PIERRE-ET-MIQUELON", false),
    VA("SAINT-SIEGE (ETAT DE LA CITE DU VATICAN)", false),
    VC("SAINT-VINCENT-ET-LES GRENADINES", false),
    SB("SALOMON, ILES", false),
    WS("SAMOA", false),
    AS("SAMOA AMERICAINES", false),
    ST("SAO TOME-ET-PRINCIPE", false),
    SN("SENEGAL", false),
    RS("SERBIE", false),
    SC("SEYCHELLES", false),
    SL("SIERRA LEONE", false),
    SG("SINGAPOUR", false),
    SK("SLOVAQUIE", true),
    SI("SLOVENIE", true),
    SO("SOMALIE", false),
    SD("SOUDAN", false),
    LK("SRI LANKA (CEYLAN)", false),
    SE("SUEDE", true),
    CH("SUISSE", false),
    SR("SURINAME", false),
    SJ("SVALBARD ET ILE JAN MAYEN", false),
    SZ("SWAZILAND", false),
    SY("SYRIENNE, REPUBLIQUE ARABE", false),
    TJ("TADJIKISTAN", false),
    TW("TAIWAN, PROVINCE DE CHINE", false),
    TZ("TANZANIE, REPUBLIQUE-UNIE DE", false),
    TD("TCHAD", false),
    CZ("TCHEQUE, REPUBLIQUE", true),
    TF("TERRES AUSTRALES FRANCAISES", false),
    TH("THAILANDE", false),
    TI("TIBET", false),
    TL("TIMOR-LESTE", false),
    TG("TOGO", false),
    TK("TOKELAU", false),
    TO("TONGA", false),
    TT("TRINITE-ET-TOBAGO", false),
    TN("TUNISIE", false),
    TM("TURKMENISTAN", false),
    TC("TURKS ET CAIQUES, ILES", false),
    TR("TURQUIE", false),
    TV("TUVALU", false),
    UA("UKRAINE", false),
    UY("URUGUAY", false),
    VU("VANUATU", false),
    VE("VENEZUELA, REPUBLIQUE BOLIVARIENNE DU", false),
    VN("VIET NAM", false),
    WF("WALLIS ET FUTUNA", false),
    YE("YEMEN", false),
    ZM("ZAMBIE", false),
    ZW("ZIMBABWE", false);

    protected String country;

    protected boolean eu;

    private Country(String country, boolean eu) {
        this.country = country;
        this.eu = eu;
    }

    public String getCountry() {
        return country;
    }

    public boolean isEu() {
        return eu;
    }
}
