/*
 * #%L
 * SGQ :: Business
 * $Id: InventoryImportModel.java 155 2012-10-10 11:05:25Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.4/sgq-business/src/main/java/com/herbocailleau/sgq/business/services/csv/InventoryImportModel.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business.services.csv;

import static org.nuiton.i18n.I18n._;

import java.text.ParseException;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.csv.ValueParser;
import org.nuiton.util.csv.ext.AbstractImportModel;

import com.herbocailleau.sgq.business.SgqBusinessException;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.PresentationCode;

/**
 * Zone, Emplacement, Code présentation, Code produit, Nom produit, Lot, DLUO, Quantité, Valeur relevée
 * 
 * @author echatellier
 */
public class InventoryImportModel extends AbstractImportModel<InventoryBean> {

    public InventoryImportModel(final Map<Integer, Batch> batchCache) {
        super(';');

        newIgnoredColumn("Zone");
        newIgnoredColumn("Emplacement");
        newMandatoryColumn("Code présentation", InventoryBean.PROPERTY_PRESENTATION_CODE, new ValueParser<PresentationCode>() {
            @Override
            public PresentationCode parse(String value) throws ParseException {
                // can be empty
                PresentationCode result = null;
                if (StringUtils.isNotBlank(value)) {
                    result = PresentationCode.getPresentationCodeFor(value.trim().charAt(0));
                }
                return result;
            }
        });
        newIgnoredColumn("Code produit");
        newIgnoredColumn("Nom produit");
        newMandatoryColumn("Lot", InventoryBean.PROPERTY_BATCH, new ValueParser<Batch>() {
            @Override
            public Batch parse(String value) throws ParseException {
                // can be empty
                Batch result = null;
                if (StringUtils.isNotBlank(value)) {
                    Integer number = Integer.valueOf(value.trim());
                    result = batchCache.get(number);
                    if (result == null) {
                        throw new SgqBusinessException(_("Impossible de trouver le lot %s", value));
                    }
                }
                return result;
            }
        });
        newIgnoredColumn("DLUO");
        newIgnoredColumn("Quantité");
        newMandatoryColumn("Valeur relevée", InventoryBean.PROPERTY_REAL_QUANTITY, new ValueParser<Double>() {
            @Override
            public Double parse(String value) throws ParseException {
                Double result = null;
                // can be null
                if (StringUtils.isNotBlank(value)) {
                    result = Double.valueOf(value.trim());
                }
                return result;
            }
        });
        
    }

    @Override
    public InventoryBean newEmptyInstance() {
        return new InventoryBean();
    }
}
