/*
 * #%L
 * SGQ :: Business
 * $Id: ClientImportModel.java 113 2012-10-02 14:38:07Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.4/sgq-business/src/main/java/com/herbocailleau/sgq/business/services/csv/ClientImportModel.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business.services.csv;

import java.text.ParseException;

import org.nuiton.util.csv.ValueParser;
import org.nuiton.util.csv.ext.AbstractImportModel;

import com.herbocailleau.sgq.entities.Client;
import com.herbocailleau.sgq.entities.ClientImpl;

/**
 * Modèle d'import du fichier CSV des clients;
 * 
 * "CODE_CLI_R";"CLI_R"
 * 
 * @author echatellier
 */
public class ClientImportModel extends AbstractImportModel<Client> {

    public ClientImportModel() {
        super(';');
        newMandatoryColumn("CODE_CLI_R", Client.PROPERTY_CODE);
        newMandatoryColumn("CLI_R", Client.PROPERTY_NAME, new ValueParser<String>() {
            @Override
            public String parse(String value) throws ParseException {
                return value.trim();
            }
        });
    }

    @Override
    public Client newEmptyInstance() {
        return new ClientImpl();
    }
}
