/*
 * #%L
 * SGQ :: Business
 * $Id: ProductDAOImpl.java 67 2012-09-17 16:31:39Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.3/sgq-business/src/main/java/com/herbocailleau/sgq/entities/ProductDAOImpl.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.entities;

import java.util.List;

import org.nuiton.topia.TopiaException;

public class ProductDAOImpl<E extends Product> extends ProductDAOAbstract<E> {

    /**
     * Extrait des produits les valeurs distinctes des categories de produit.
     * 
     * @return les categories utilisées par les produits
     * @throws TopiaException 
     */
    public List<String> findDistinctCategories() throws TopiaException {
        String query = "select distinct " + Product.PROPERTY_CATEGORY +
            " from " + Product.class.getName();

        List<String> result = context.findAll(query);
        return result;
    }

} //ProductDAOImpl<E extends Product>
