/*
 * #%L
 * SGQ :: Business
 * $Id: PresentationDAOImpl.java 113 2012-10-02 14:38:07Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.3/sgq-business/src/main/java/com/herbocailleau/sgq/entities/PresentationDAOImpl.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.entities;

import java.util.List;

import org.nuiton.topia.TopiaException;

public class PresentationDAOImpl<E extends Presentation> extends PresentationDAOAbstract<E> {

    /**
     * Retourne les presentations d'un lot ordonées par le code presentation.
     * 
     * @param batch batch
     * @return batch presentation
     * @throws TopiaException 
     */
    public List<Presentation> findAllByBatchOrderByPresentation(Batch batch) throws TopiaException {
        String query = "from " + Presentation.class.getName() +
                " where " + Presentation.PROPERTY_BATCH + " = :batch" +
                " order by " + Presentation.PROPERTY_PRESENTATION_CODE + " ASC";
        
        List<Presentation> result = context.findAll(query, "batch", batch);
        return result;
    }

} //PresentationDAOImpl<E extends Presentation>
