package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.SGQDAOHelper.SGQEntityEnum;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class AnalyzeFileDAOAbstract<E extends AnalyzeFile> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)AnalyzeFile.class;
    }

    @Override
    public SGQEntityEnum getTopiaEntityEnum() {
        return SGQEntityEnum.AnalyzeFile;
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(AnalyzeFile.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(AnalyzeFile.PROPERTY_NAME, v);
        return result;
    }

    public E findByData(Blob v) throws TopiaException {
        E result = findByProperty(AnalyzeFile.PROPERTY_DATA, v);
        return result;
    }

    public List<E> findAllByData(Blob v) throws TopiaException {
        List<E> result = findAllByProperty(AnalyzeFile.PROPERTY_DATA, v);
        return result;
    }

    public E findByAnalyze(Analyze v) throws TopiaException {
        E result = findByProperty(AnalyzeFile.PROPERTY_ANALYZE, v);
        return result;
    }

    public List<E> findAllByAnalyze(Analyze v) throws TopiaException {
        List<E> result = findAllByProperty(AnalyzeFile.PROPERTY_ANALYZE, v);
        return result;
    }

    public E findByBatch(Batch v) throws TopiaException {
        E result = findByProperty(AnalyzeFile.PROPERTY_BATCH, v);
        return result;
    }

    public List<E> findAllByBatch(Batch v) throws TopiaException {
        List<E> result = findAllByProperty(AnalyzeFile.PROPERTY_BATCH, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

} //AnalyzeFileDAOAbstract<E extends AnalyzeFile>
