/*
 * #%L
 * SGQ :: Business
 * $Id: AnalyzeDAOImpl.java 77 2012-09-19 16:32:29Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.3/sgq-business/src/main/java/com/herbocailleau/sgq/entities/AnalyzeDAOImpl.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.entities;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.TopiaException;

import com.herbocailleau.sgq.business.model.AnalyzeFilter;

public class AnalyzeDAOImpl<E extends Analyze> extends AnalyzeDAOAbstract<E> {

    /**
     * Retourne l'ensemble des analyzes a preparer et non encore expédiées.
     * 
     * @param analyzeFilter filter to filter on
     * @throws TopiaException 
     */
    public List<Analyze> findAllAnalyzeToSend(AnalyzeFilter analyzeFilter) throws TopiaException {
        String query = "from " + Analyze.class.getName() +
            " where " + Analyze.PROPERTY_SENT_DATE + " is null";
        return findAllAnalyzeWithQuery(analyzeFilter, query);
    }

    /**
     * Retourne l'ensemble des analyzes expédiées en attente de reception.
     * 
     * @param analyzeFilter filter to filter on
     * @throws TopiaException 
     */
    public List<Analyze> findAllAnalyzeToReceive(AnalyzeFilter analyzeFilter) throws TopiaException {
        String query = "from " + Analyze.class.getName() +
            " where " + Analyze.PROPERTY_RECEIPT_DATE + " is null" +
            " and " + Analyze.PROPERTY_SENT_DATE + " is not null";
        return findAllAnalyzeWithQuery(analyzeFilter, query);
    }
    
    /**
     * Retourne l'ensemble des analyzes en utilisant le filtre et le
     * debut de requete.
     * 
     * @param analyzeFilter filter
     * @param queryPrefix query prefix
     * @throws TopiaException 
     */
    protected List<Analyze> findAllAnalyzeWithQuery(AnalyzeFilter analyzeFilter, String queryPrefix) throws TopiaException {
        String query = queryPrefix;
        
        // build query and params
        List<Object> params = new ArrayList<Object>();
        if (analyzeFilter.getAnalyzeType() != null) {
            query += " and " + Analyze.PROPERTY_ANALYZE_TYPE + " = :analyzeType";
            params.add("analyzeType");
            params.add(analyzeFilter.getAnalyzeType());
        }
        if (analyzeFilter.getBatchNumberBegin() > 0) {
            query += " and :batchNumberBegin <= " + Analyze.PROPERTY_BATCH + "."  + Batch.PROPERTY_NUMBER;
            params.add("batchNumberBegin");
            params.add(analyzeFilter.getBatchNumberBegin());
        }
        if (analyzeFilter.getBatchNumberEnd() > 0) {
            query += " and " + Analyze.PROPERTY_BATCH + "."  + Batch.PROPERTY_NUMBER + " <= :batchNumberEnd";
            params.add("batchNumberEnd");
            params.add(analyzeFilter.getBatchNumberEnd());
        }
        if (StringUtils.isNotBlank(analyzeFilter.getSupplier())) {
            query += " and " + Analyze.PROPERTY_SUPPLIER +
                    "." + Supplier.PROPERTY_NAME + " LIKE :supplier";
            params.add("supplier");
            params.add("%" + analyzeFilter.getSupplier() + "%");
        }
        query += " order by " + Analyze.PROPERTY_BATCH + "." + Batch.PROPERTY_DPMES;

        // execute query
        List<Analyze> result= context.findAll(query, params.toArray());
        return result;
    }

} //AnalyzeDAOImpl<E extends Analyze>
