/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.SGQDAOHelper;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.Place;
import com.herbocailleau.sgq.entities.Presentation;
import com.herbocailleau.sgq.entities.PresentationCode;
import com.herbocailleau.sgq.entities.Sale;
import com.herbocailleau.sgq.entities.SaleDAO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class PresentationDAOAbstract<E extends Presentation>
extends TopiaDAOImpl<E> {
    public Class<E> getEntityClass() {
        return Presentation.class;
    }

    public SGQDAOHelper.SGQEntityEnum getTopiaEntityEnum() {
        return SGQDAOHelper.SGQEntityEnum.Presentation;
    }

    public void delete(E entity) throws TopiaException {
        List list = this.getContext().getDAO(Sale.class).findAllByProperties("presentation", entity, new Object[0]);
        for (Sale item : list) {
            if (!entity.equals(item.getPresentation())) continue;
            item.setPresentation(null);
        }
        super.delete(entity);
    }

    public E findByName(String v) throws TopiaException {
        Presentation result = (Presentation)this.findByProperty("name", v);
        return (E)result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List result = this.findAllByProperty("name", v);
        return result;
    }

    public E findByQuantity(double v) throws TopiaException {
        Presentation result = (Presentation)this.findByProperty("quantity", v);
        return (E)result;
    }

    public List<E> findAllByQuantity(double v) throws TopiaException {
        List result = this.findAllByProperty("quantity", v);
        return result;
    }

    public E findByUnit(String v) throws TopiaException {
        Presentation result = (Presentation)this.findByProperty("unit", v);
        return (E)result;
    }

    public List<E> findAllByUnit(String v) throws TopiaException {
        List result = this.findAllByProperty("unit", v);
        return result;
    }

    public E findByPlace(Place v) throws TopiaException {
        Presentation result = (Presentation)this.findByProperty("place", v);
        return (E)result;
    }

    public List<E> findAllByPlace(Place v) throws TopiaException {
        List result = this.findAllByProperty("place", v);
        return result;
    }

    public E findByBatch(Batch v) throws TopiaException {
        Presentation result = (Presentation)this.findByProperty("batch", v);
        return (E)result;
    }

    public List<E> findAllByBatch(Batch v) throws TopiaException {
        List result = this.findAllByProperty("batch", v);
        return result;
    }

    public E findByPresentationCode(PresentationCode v) throws TopiaException {
        Presentation result = (Presentation)this.findByProperty("presentationCode", (Object)v);
        return (E)result;
    }

    public List<E> findAllByPresentationCode(PresentationCode v) throws TopiaException {
        List result = this.findAllByProperty("presentationCode", (Object)v);
        return result;
    }

    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        ArrayList result = new ArrayList();
        if (type == Sale.class) {
            SaleDAO dao = (SaleDAO)this.getContext().getDAO(Sale.class);
            List tmp = dao.findAllByPresentation((Presentation)entity);
            result.addAll(tmp);
        }
        return result;
    }

    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);
        List<Sale> list = this.findUsages(Sale.class, entity);
        if (!list.isEmpty()) {
            result.put(Sale.class, list);
        }
        return result;
    }
}

