/*
 * #%L
 * SGQ :: Business
 * $Id: BatchModel.java 50 2012-09-11 13:52:49Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.2/sgq-business/src/main/java/com/herbocailleau/sgq/business/model/BatchModel.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business.model;

import com.herbocailleau.sgq.entities.Batch;

/**
 * Model de presentation d'un lot, englobant en plus la quantité totale
 * restante suivant les quantités des présentations.
 * 
 * @author echatellier
 */
public class BatchModel {

    protected Batch batch;

    protected double totalQuantity;

    public BatchModel(Batch batch, double totalQuantity) {
        this.batch = batch;
        this.totalQuantity = totalQuantity;
    }

    public Batch getBatch() {
        return batch;
    }

    public double getTotalQuantity() {
        return totalQuantity;
    }
}
