package com.herbocailleau.sgq.entities;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class SaleAbstract extends TopiaEntityAbstract implements Sale {

    /**
     * Nom de l'attribut en BD : date
     */
    protected Date date;

    /**
     * Nom de l'attribut en BD : quantity
     */
    protected double quantity;

    /**
     * Nom de l'attribut en BD : presentation
     */
    protected Presentation presentation;

    /**
     * Nom de l'attribut en BD : client
     */
    protected Client client;

    private static final long serialVersionUID = 7219613470188659767L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, DATE, Date.class, date);
        visitor.visit(this, QUANTITY, double.class, quantity);
        visitor.visit(this, PRESENTATION, Presentation.class, presentation);
        visitor.visit(this, CLIENT, Client.class, client);
        visitor.end(this);
    }

    @Override
    public void setDate(Date date) {
        Date oldValue = this.date;
        fireOnPreWrite(DATE, oldValue, date);
        this.date = date;
        fireOnPostWrite(DATE, oldValue, date);
    }

    @Override
    public Date getDate() {
        fireOnPreRead(DATE, date);
        Date result = this.date;
        fireOnPostRead(DATE, date);
        return result;
    }

    @Override
    public void setQuantity(double quantity) {
        double oldValue = this.quantity;
        fireOnPreWrite(QUANTITY, oldValue, quantity);
        this.quantity = quantity;
        fireOnPostWrite(QUANTITY, oldValue, quantity);
    }

    @Override
    public double getQuantity() {
        fireOnPreRead(QUANTITY, quantity);
        double result = this.quantity;
        fireOnPostRead(QUANTITY, quantity);
        return result;
    }

    @Override
    public void setPresentation(Presentation presentation) {
        Presentation oldValue = this.presentation;
        fireOnPreWrite(PRESENTATION, oldValue, presentation);
        this.presentation = presentation;
        fireOnPostWrite(PRESENTATION, oldValue, presentation);
    }

    @Override
    public Presentation getPresentation() {
        fireOnPreRead(PRESENTATION, presentation);
        Presentation result = this.presentation;
        fireOnPostRead(PRESENTATION, presentation);
        return result;
    }

    @Override
    public void setClient(Client client) {
        Client oldValue = this.client;
        fireOnPreWrite(CLIENT, oldValue, client);
        this.client = client;
        fireOnPostWrite(CLIENT, oldValue, client);
    }

    @Override
    public Client getClient() {
        fireOnPreRead(CLIENT, client);
        Client result = this.client;
        fireOnPostRead(CLIENT, client);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(DATE, this.date).
            append(QUANTITY, this.quantity).
            append(PRESENTATION, this.presentation).
            append(CLIENT, this.client).
         toString();
        return result;
    }

} //SaleAbstract
