package com.herbocailleau.sgq.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class PresentationAbstract extends TopiaEntityAbstract implements Presentation {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : quantity
     */
    protected double quantity;

    /**
     * Nom de l'attribut en BD : unit
     */
    protected String unit;

    /**
     * Nom de l'attribut en BD : place
     */
    protected Place place;

    /**
     * Nom de l'attribut en BD : batch
     */
    protected Batch batch;

    private static final long serialVersionUID = 7005457395135558704L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, NAME, String.class, name);
        visitor.visit(this, QUANTITY, double.class, quantity);
        visitor.visit(this, UNIT, String.class, unit);
        visitor.visit(this, PLACE, Place.class, place);
        visitor.visit(this, BATCH, Batch.class, batch);
        visitor.end(this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(NAME, name);
        String result = this.name;
        fireOnPostRead(NAME, name);
        return result;
    }

    @Override
    public void setQuantity(double quantity) {
        double oldValue = this.quantity;
        fireOnPreWrite(QUANTITY, oldValue, quantity);
        this.quantity = quantity;
        fireOnPostWrite(QUANTITY, oldValue, quantity);
    }

    @Override
    public double getQuantity() {
        fireOnPreRead(QUANTITY, quantity);
        double result = this.quantity;
        fireOnPostRead(QUANTITY, quantity);
        return result;
    }

    @Override
    public void setUnit(String unit) {
        String oldValue = this.unit;
        fireOnPreWrite(UNIT, oldValue, unit);
        this.unit = unit;
        fireOnPostWrite(UNIT, oldValue, unit);
    }

    @Override
    public String getUnit() {
        fireOnPreRead(UNIT, unit);
        String result = this.unit;
        fireOnPostRead(UNIT, unit);
        return result;
    }

    @Override
    public void setPlace(Place place) {
        Place oldValue = this.place;
        fireOnPreWrite(PLACE, oldValue, place);
        this.place = place;
        fireOnPostWrite(PLACE, oldValue, place);
    }

    @Override
    public Place getPlace() {
        fireOnPreRead(PLACE, place);
        Place result = this.place;
        fireOnPostRead(PLACE, place);
        return result;
    }

    @Override
    public void setBatch(Batch batch) {
        Batch oldValue = this.batch;
        fireOnPreWrite(BATCH, oldValue, batch);
        this.batch = batch;
        fireOnPostWrite(BATCH, oldValue, batch);
    }

    @Override
    public Batch getBatch() {
        fireOnPreRead(BATCH, batch);
        Batch result = this.batch;
        fireOnPostRead(BATCH, batch);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(NAME, this.name).
            append(QUANTITY, this.quantity).
            append(UNIT, this.unit).
            append(BATCH, this.batch).
            append(PLACE, this.place).
            append(BATCH, this.batch).
         toString();
        return result;
    }

} //PresentationAbstract
