package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.SGQDAOHelper.SGQEntityEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class AnalyzeDAOAbstract<E extends Analyze> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Analyze.class;
    }

    @Override
    public SGQEntityEnum getTopiaEntityEnum() {
        return SGQEntityEnum.Analyze;
    }

    public E findByCreationDate(Date v) throws TopiaException {
        E result = findByProperty(Analyze.CREATION_DATE, v);
        return result;
    }

    public List<E> findAllByCreationDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Analyze.CREATION_DATE, v);
        return result;
    }

    public E findBySentDate(Date v) throws TopiaException {
        E result = findByProperty(Analyze.SENT_DATE, v);
        return result;
    }

    public List<E> findAllBySentDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Analyze.SENT_DATE, v);
        return result;
    }

    public E findByReceiptDate(Date v) throws TopiaException {
        E result = findByProperty(Analyze.RECEIPT_DATE, v);
        return result;
    }

    public List<E> findAllByReceiptDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Analyze.RECEIPT_DATE, v);
        return result;
    }

    public E findByAnalyzeType(AnalyzeType v) throws TopiaException {
        E result = findByProperty(Analyze.ANALYZE_TYPE, v);
        return result;
    }

    public List<E> findAllByAnalyzeType(AnalyzeType v) throws TopiaException {
        List<E> result = findAllByProperty(Analyze.ANALYZE_TYPE, v);
        return result;
    }

    public E findContainsAnalyzeFile(AnalyzeFile v) throws TopiaException {
        E result = findContains(Analyze.ANALYZE_FILE, v);
        return result;
    }

    public List<E> findAllContainsAnalyzeFile(AnalyzeFile v) throws TopiaException {
        List<E> result = findAllContains(Analyze.ANALYZE_FILE, v);
        return result;
    }

    public E findByBatch(Batch v) throws TopiaException {
        E result = findByProperty(Analyze.BATCH, v);
        return result;
    }

    public List<E> findAllByBatch(Batch v) throws TopiaException {
        List<E> result = findAllByProperty(Analyze.BATCH, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Batch.class) {
            BatchDAO dao = (BatchDAO)
                getContext().getDAO(Batch.class);
            tmp = dao.findAllContainsAnalyze(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Batch.class, entity);
        if (!list.isEmpty()) {
            result.put(Batch.class, list);
        }

        return result;
    }

} //AnalyzeDAOAbstract<E extends Analyze>
