/*
 * #%L
 * SGQ :: Business
 * $Id: DataRecoveryService.java 29 2012-08-20 13:58:05Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.1/sgq-business/src/main/java/com/herbocailleau/sgq/business/DataRecoveryService.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business;


import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;

import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Row;

public class DataRecoveryService {

    /**
     * Import du fichier numéro de lot.
     * 
     * @param batchFile fichier numero lot
     */
    public void importBatchFile(File batchFile) {
        
        FileInputStream batchStream = null;
        try {
            batchStream = new FileInputStream(batchFile);
            
            POIFSFileSystem myFileSystem = new POIFSFileSystem(batchStream);
            HSSFWorkbook myWorkBook = new HSSFWorkbook(myFileSystem);

            HSSFSheet mySheet = myWorkBook.getSheet("Entrées pdts");
            Iterator<Row> rowIter = mySheet.rowIterator();

            while (rowIter.hasNext()) {
                HSSFRow myRow = (HSSFRow) rowIter.next();
                System.out.println(myRow.getCell(0));
                System.out.println(myRow.getCell(10));
                HSSFComment comment = myRow.getCell(10).getCellComment();
                if (comment != null) {
                    System.out.println("comment : " + comment.getString());
                }
            }
            
            batchStream.close();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } finally {
            IOUtils.closeQuietly(batchStream);
        }
    }

    /**
     * Export le fichier d'inventaire.
     * 
     * @param inventoryFile inventory file
     */
    public void exportInventory(File inventoryFile) {

        FileOutputStream fileOut = null;

        try {
            HSSFWorkbook wb = new HSSFWorkbook();

            HSSFSheet sheet = wb.createSheet();

            // header
            HSSFRow headerRow = sheet.createRow(0);
            headerRow.createCell(0).setCellValue("Lot");

            // data
            HSSFRow row = sheet.createRow(1);
            HSSFCell cell = row.createCell(0);
            cell.setCellValue(1);
            row = sheet.createRow(2);
            cell = row.createCell(0);
            cell.setCellValue(2);

            // write it
            fileOut = new FileOutputStream(inventoryFile);
            wb.write(fileOut);
            fileOut.close();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } finally {
            IOUtils.closeQuietly(fileOut);
        }
        
    }
}
