/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.JaxxFileChooser;
import org.nuiton.util.FileUtil;

public class FileChooserUtil {
    private static final Log log = LogFactory.getLog(FileChooserUtil.class);
    public static final File DEFAULT_CURRENT_DIRECTORY_FILE;
    protected static File currentDirectory;

    public static void setCurrentDirectory(File dir) {
        JaxxFileChooser.setCurrentDirectory(currentDirectory);
    }

    public static File getCurrentDirectory() {
        return JaxxFileChooser.getCurrentDirectory();
    }

    public static boolean isCurrentDirectoryDefault() {
        return JaxxFileChooser.isCurrentDirectoryDefault();
    }

    protected FileChooserUtil() {
    }

    public static File getFile(String ... patternOrDescriptionFilters) {
        File result = FileChooserUtil.getFile(null, patternOrDescriptionFilters);
        return result;
    }

    public static File getFile(FileFilter ... filters) {
        File result = FileChooserUtil.getFile(null, filters);
        return result;
    }

    public static File getFile(Component parent, String ... patternOrDescriptionFilters) {
        File result = FileChooserUtil.getFile("Ok", "Ok", parent, patternOrDescriptionFilters);
        return result;
    }

    public static File getFile(String title, String approvalText, Component parent, String ... patternOrDescriptionFilters) {
        if (patternOrDescriptionFilters.length % 2 != 0) {
            throw new IllegalArgumentException("Arguments must be (pattern, description) couple");
        }
        FileFilter[] filters = new FileFilter[patternOrDescriptionFilters.length / 2];
        for (int i = 0; i < filters.length; ++i) {
            String pattern = patternOrDescriptionFilters[i * 2];
            String description = patternOrDescriptionFilters[i * 2 + 1];
            filters[i] = new PatternChooserFilter(pattern, description);
        }
        File result = FileChooserUtil.getFile(title, approvalText, parent, filters);
        return result;
    }

    public static File getFile(Component parent, FileFilter ... filters) {
        File result = FileChooserUtil.getFile("Ok", "Ok", parent, filters);
        return result;
    }

    public static File getFile(String title, String approvalText, Component parent, FileFilter ... filters) {
        try {
            File theFile;
            JFileChooser chooser = new JFileChooser(currentDirectory);
            chooser.setDialogType(2);
            if (filters.length > 0) {
                if (filters.length == 1) {
                    chooser.setFileFilter(filters[0]);
                } else {
                    for (FileFilter filter : filters) {
                        chooser.addChoosableFileFilter(filter);
                    }
                }
            }
            chooser.setFileSelectionMode(0);
            chooser.setDialogTitle(title);
            int returnVal = chooser.showDialog(parent, approvalText);
            if (returnVal == 0 && (theFile = chooser.getSelectedFile()) != null) {
                currentDirectory = theFile;
                return theFile.getAbsoluteFile();
            }
        }
        catch (Exception eee) {
            log.warn((Object)"Erreur:", (Throwable)eee);
        }
        return null;
    }

    public static File saveFile(String filename, String title, String approvalText, Component parent, String ... patternOrDescriptionFilters) {
        if (patternOrDescriptionFilters.length % 2 != 0) {
            throw new IllegalArgumentException("Arguments must be (pattern, description) couple");
        }
        FileFilter[] filters = new FileFilter[patternOrDescriptionFilters.length / 2];
        for (int i = 0; i < filters.length; ++i) {
            String pattern = patternOrDescriptionFilters[i * 2];
            String description = patternOrDescriptionFilters[i * 2 + 1];
            filters[i] = new FileUtil.PatternChooserFilter(pattern, description);
        }
        File result = FileChooserUtil.saveFile(filename, title, approvalText, parent, filters);
        return result;
    }

    public static File saveFile(String filename, String title, String approvalText, Component parent, FileFilter ... filters) {
        File selectedFile = new File(FileChooserUtil.getCurrentDirectory(), filename);
        JFileChooser chooser = new JFileChooser(selectedFile);
        chooser.setDialogType(1);
        chooser.setSelectedFile(selectedFile);
        if (filters.length > 0) {
            if (filters.length == 1) {
                chooser.setFileFilter(filters[0]);
            } else {
                for (FileFilter filter : filters) {
                    chooser.addChoosableFileFilter(filter);
                }
            }
        }
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle(title);
        File result = null;
        int returnVal = chooser.showDialog(parent, approvalText);
        if (returnVal == 0 && (result = chooser.getSelectedFile()) != null) {
            FileChooserUtil.setCurrentDirectory(result);
            result = result.getAbsoluteFile();
        }
        return result;
    }

    public static String getDirectory() {
        return FileChooserUtil.getDirectory(null, "Ok", "Ok");
    }

    public static String getDirectory(String title, String approvalText) {
        String result = FileChooserUtil.getDirectory(null, title, approvalText);
        return result;
    }

    public static String getDirectory(Component parent, String title, String approvalText) {
        block5: {
            try {
                JFileChooser chooser = new JFileChooser(currentDirectory);
                chooser.setDialogType(2);
                chooser.setFileSelectionMode(1);
                chooser.setDialogTitle(title);
                int returnVal = chooser.showDialog(parent, approvalText);
                if (returnVal == 0) {
                    File theFile = chooser.getSelectedFile();
                    if (theFile != null) {
                        currentDirectory = theFile;
                        if (theFile.isDirectory()) {
                            return theFile.getAbsolutePath();
                        }
                    }
                    break block5;
                }
                return null;
            }
            catch (Exception eee) {
                log.warn((Object)"Erreur:", (Throwable)eee);
            }
        }
        return null;
    }

    static {
        currentDirectory = DEFAULT_CURRENT_DIRECTORY_FILE = new File(".");
    }

    public static class PatternChooserFilter
    extends FileFilter {
        protected String pattern;
        protected String description;

        public PatternChooserFilter(String pattern, String description) {
            this.pattern = pattern;
            this.description = description;
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getAbsolutePath().matches(this.pattern);
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

