/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.PostConnectProcessor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.extensions.StartTLSExtendedRequest;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import javax.net.ssl.SSLContext;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class StartTLSPostConnectProcessor
implements PostConnectProcessor {
    private final SSLContext sslContext;

    public StartTLSPostConnectProcessor(SSLContext sslContext) {
        Validator.ensureNotNull(sslContext);
        this.sslContext = sslContext;
    }

    public void processPreAuthenticatedConnection(LDAPConnection connection) throws LDAPException {
        StartTLSExtendedRequest startTLSRequest = new StartTLSExtendedRequest(this.sslContext);
        LDAPConnectionOptions opts = connection.getConnectionOptions();
        startTLSRequest.setResponseTimeoutMillis(opts.getConnectTimeoutMillis());
        ExtendedResult r = connection.processExtendedOperation(startTLSRequest);
        if (!r.getResultCode().equals(ResultCode.SUCCESS)) {
            throw new LDAPException(r);
        }
    }

    public void processPostAuthenticatedConnection(LDAPConnection connection) throws LDAPException {
    }
}

