package com.franciaflex.faxtomail.ui.swing.content.pdfeditor;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.util.JImagePanel;
import com.itextpdf.text.pdf.BaseFont;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class PDFEditorStampTextUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_TEXT = "text";
    public static final String PROPERTY_ZOOM = "zoom";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_STAMP_TEXT_FONT_SIZE = "stampText.font-size";
    public static final String BINDING_STAMP_TEXT_TEXT = "stampText.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1UTW8bRRgeu7ETp4F+RI1aUaTF7cEO7rr0ViVKazte1WVpozqtojiond0dJ1tmd6azs82mFoifwE+AOxckbpwQB84cuCD+AkIcuCLe2V3vxslCGjnr9czzPu/zfn77B6oEAn3wEkeRLkJfuh7RH3Z2dh5bL4ktN0lgC5dLJlDyVyqj8gidd7LzQKIbI1OZt1Pzdo95nPnEP2a9ZqLFQB5REhwQIiV6f9bCDoL2MLtei3gopqyZqCLWr//6s/yV8+U3ZYQiDuqqEIp2llUeyZyJyq4j0WXw9Bq3Kfb3QYZw/X3Q+44661EcBI+wR16hL9C8iaocCyCTqP72IcccsX3EpTrDHt/CPqESDWzm6WOBfdvFY0oifYwjyTzsUj109eAQlOg28yUQ69wZE8cFYn1r0+jHb0NFtU0i+XTAeeyiKtGchAOJLir5ugpJT0I6hnjDmCfRhRxhUIZlDli4+TAWeBtSo0BRKiU5VaBahl0SxGOvSTeUEoSi5Rl8cqqQlzODWjBVfZLdxFbGLtB7M3WEDtHzDslLWBqhigjhWKKro9NN9QSukna6eqKdFGF8+8/K8q8//P69Me2hefB9pRB6bASgtlwwToR0lesLSQOF0qXtTzBfG0GUhML8xPNxvUDYML0GceDvUlwKZa4/wMEBUFTmf/vxp5UXv5xDZQMtQnkcAyv8ANXkgYAsMOpE/N79WNHS4QI8L8J/WaIq4/hVCDmqjDEN4HvRwvZn+4KFPrT6wkTzQ0q1zyPIyfWCnGTCrNrPfy8Pv7s/zUsJdF77T3iem8ouqro+dX0ST1c6OIXTdJ4HJHRYPiBFI4NgaGrZfKVNqsXPm6fiL0EtPBy5Xug9YYc9iBm6rHzndhQq/KrKUGzZUqwrXYJ9w6WSCGyBU+ZZrMui1EUMWVKQExf/47tqMeFAU6D2ROvGr0nVjnRbECxJ3+PyKLlo3Glp6aepqjHVV0qdz2wKfobruWzsz2k7GsgeMzsMtrALq8PJOyGTd7dYnglFS9X1GIVN0zU7vY9b2kctLWYAoRJdShdSB0wgeTR3UBTEzHp4+zA6E62+fiA9ulHXPtT2iVT7otHUBeEU26RDaaM+2vP3xKf1FiAt0d6oNwFZX28nViB0bsxU9W9MNANedIfYzCGNLg5I/PtB33zW3x70OnFUNQW+FbhvIE2rE60xVhux2djsG52n5vZz4/Gj7efDwW5fW1VqdmGBNpqxYZbTY5N1Og350jsrB6qLKD5ikDD07rqDJdYs13dgQW6cIi6p5+KZjOp4pB57xQzLwPAvxHuCUAgIAAA=";
    private static final Log log = LogFactory.getLog(PDFEditorStampTextUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton removeButton;
    protected PDFEditorStampTextUI stampPanel = this;
    protected JLabel stampText;
    protected String text;
    protected Float zoom;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public static final int DEFAULT_FONT_SIZE = 12;
    
    
        protected void pack() {
            JPanel container = getParentContainer(JPanel.class);
            Point location = getLocation();
            Insets containerInsets = container.getInsets();
            Dimension size = getPreferredSize();
            setBounds(location.x + containerInsets.left,
                      location.y + containerInsets.top,
                      size.width,
                      size.height);
        }
    
        protected void removeStamp() {
            JPanel container = getParentContainer(JPanel.class);
            container.remove(this);
            container.updateUI();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PDFEditorStampTextUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PDFEditorStampTextUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PDFEditorStampTextUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PDFEditorStampTextUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PDFEditorStampTextUI() {
        $initialize();
    }

    public PDFEditorStampTextUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PDFEditorStampTextUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PDFEditorStampTextUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__removeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        removeStamp();
    }

    public void doComponentResized__on__stampPanel(ComponentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        pack();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getRemoveButton() {
        return removeButton;
    }

    public JLabel getStampText() {
        return stampText;
    }

    public String getText() {
        return text;
    }

    public Float getZoom() {
        return zoom;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setText(String text) {
        String oldValue = this.text;
        this.text = text;
        firePropertyChange(PROPERTY_TEXT, oldValue, text);
    }

    public void setZoom(Float zoom) {
        Float oldValue = this.zoom;
        this.zoom = zoom;
        firePropertyChange(PROPERTY_ZOOM, oldValue, zoom);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToStampPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add($JPanel0, BorderLayout.EAST);
        add(stampText, BorderLayout.CENTER);
    }

    protected void createRemoveButton() {
        $objectMap.put("removeButton", removeButton = new JButton());
        
        removeButton.setName("removeButton");
        removeButton.setText(t(" X "));
        removeButton.setFocusPainted(false);
        removeButton.setOpaque(false);
        removeButton.setContentAreaFilled(false);
        removeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeButton"));
    }

    protected void createStampText() {
        $objectMap.put("stampText", stampText = new JLabel());
        
        stampText.setName("stampText");
        stampText.setOpaque(false);
    }

    protected void createText() {
        $objectMap.put("text", text = new String());
    }

    protected void createZoom() {
        $objectMap.put("zoom", zoom = 1.0f);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToStampPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(removeButton, BorderLayout.NORTH);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        setBackground( null );
        setBorder( BorderFactory.createEmptyBorder(2, 2, 2, 2) );
        $JPanel0.setBackground( null );
        removeButton.setBackground( null );
        removeButton.setBorder( BorderFactory.createLineBorder(Color.BLACK, 1, false) );
        stampText.setFont( Font.decode(BaseFont.HELVETICA) );
        stampText.setBackground( null );
        stampText.setBorder( null );
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("stampPanel", stampPanel);
        createText();
        createZoom();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout( new BorderLayout() );
        $JPanel0.setOpaque(false);
        createRemoveButton();
        createStampText();
        // inline creation of stampPanel
        setName("stampPanel");
        setLayout(new BorderLayout());
        setOpaque(false);
        stampPanel.addComponentListener(JAXXUtil.getEventListener(ComponentListener.class, "componentResized", this, "doComponentResized__on__stampPanel"));
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STAMP_TEXT_TEXT, true ,"text") {
        
            @Override
            public void processDataBinding() {
                if (getText() != null) {
                    stampText.setText(t( "<html>" + getText().replaceAll("[\n\r]", "<br/>") + "</html>"));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STAMP_TEXT_FONT_SIZE, true ,"DEFAULT_FONT_SIZE" ,"zoom") {
        
            @Override
            public void processDataBinding() {
                if (stampText.getFont() != null) {
                    stampText.setFont(stampText.getFont().deriveFont((float)  (float)(DEFAULT_FONT_SIZE * getZoom()) ));
                }
            }
        });
    }

}