package com.franciaflex.faxtomail.ui.swing.actions;

/*
 * #%L
 * FaxToMail :: UI
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2014 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.Range;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.ui.swing.content.demande.QuantitiesByRangeUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.QuantitiesByRangeUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.QuantitiesByRangeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.RangeRowModel;

import java.awt.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static org.nuiton.i18n.I18n.t;

/**
 * @author Kevin Morin (Code Lutin)
 *
 */
public class ComputeQuantitiesByRangeAction extends AbstractFaxToMailAction<QuantitiesByRangeUIModel, QuantitiesByRangeUI, QuantitiesByRangeUIHandler> {

    public ComputeQuantitiesByRangeAction(QuantitiesByRangeUIHandler handler) {
        super(handler, false);
        setActionDescription(t("faxtomail.action.computeQuantitiesByRange.tip"));
    }

    @Override
    public void doAction() throws Exception {
        MailFolder folder = getModel().getRootFolder();
        FaxToMailServiceContext serviceContext = getContext().newServiceContext();
        Map<Range, Long[]> quantitiesByRange = serviceContext.getEmailService().computeQuantitiesByRange(folder);

        List<RangeRowModel> rangeRows = new ArrayList<>();
        for (Range range : quantitiesByRange.keySet()) {
            RangeRowModel row = new RangeRowModel();
            row.setRange(range);

            Long[] quantities = quantitiesByRange.get(range);

            Long productQuantity = quantities[0];
            if (productQuantity == null) {
                productQuantity = 0L;
            }
            row.setProductQuantity(productQuantity.intValue());

            Long savQuantity = quantities[1];
            if (savQuantity == null) {
                savQuantity = 0L;
            }
            row.setSavQuantity(savQuantity.intValue());

            Long quotationQuantity = quantities[2];
            if (quotationQuantity == null) {
                quotationQuantity = 0L;
            }
            row.setQuotationQuantity(quotationQuantity.intValue());

            rangeRows.add(row);
        }
        getModel().setRangeRows(rangeRows);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        handler.openDialog(getUI(), t("faxtomail.quantitiesByRange.title"), new Dimension(350, 300));
    }
}
