/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InternalUseOnly
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ModifyRequestProtocolOp
implements ProtocolOp {
    private static final long serialVersionUID = -6294739625253826184L;
    private final List<Modification> modifications;
    private final String dn;

    public ModifyRequestProtocolOp(String dn, List<Modification> modifications) {
        this.dn = dn;
        this.modifications = Collections.unmodifiableList(modifications);
    }

    public ModifyRequestProtocolOp(ModifyRequest request) {
        this.dn = request.getDN();
        this.modifications = request.getModifications();
    }

    ModifyRequestProtocolOp(ASN1StreamReader reader) throws LDAPException {
        try {
            reader.beginSequence();
            this.dn = reader.readString();
            Validator.ensureNotNull(this.dn);
            ArrayList<Modification> mods = new ArrayList<Modification>(5);
            ASN1StreamReaderSequence modSequence = reader.beginSequence();
            while (modSequence.hasMoreElements()) {
                mods.add(Modification.readFrom(reader));
            }
            this.modifications = Collections.unmodifiableList(mods);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MODIFY_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public String getDN() {
        return this.dn;
    }

    public List<Modification> getModifications() {
        return this.modifications;
    }

    @Override
    public byte getProtocolOpType() {
        return 102;
    }

    @Override
    public ASN1Element encodeProtocolOp() {
        ArrayList<ASN1Sequence> modElements = new ArrayList<ASN1Sequence>(this.modifications.size());
        for (Modification m : this.modifications) {
            modElements.add(m.encode());
        }
        return new ASN1Sequence(102, new ASN1OctetString(this.dn), new ASN1Sequence(modElements));
    }

    public static ModifyRequestProtocolOp decodeProtocolOp(ASN1Element element) throws LDAPException {
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(element).elements();
            String dn = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
            ASN1Element[] modElements = ASN1Sequence.decodeAsSequence(elements[1]).elements();
            ArrayList<Modification> mods = new ArrayList<Modification>(modElements.length);
            for (ASN1Element e : modElements) {
                mods.add(Modification.decode(ASN1Sequence.decodeAsSequence(e)));
            }
            return new ModifyRequestProtocolOp(dn, mods);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MODIFY_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    public void writeTo(ASN1Buffer writer) {
        ASN1BufferSequence opSequence = writer.beginSequence((byte)102);
        writer.addOctetString(this.dn);
        ASN1BufferSequence modSequence = writer.beginSequence();
        for (Modification m : this.modifications) {
            m.writeTo(writer);
        }
        modSequence.end();
        opSequence.end();
    }

    public ModifyRequest toModifyRequest(Control ... controls) {
        return new ModifyRequest(this.dn, this.modifications, controls);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("ModifyRequestProtocolOp(dn='");
        buffer.append(this.dn);
        buffer.append("', mods={");
        Iterator<Modification> iterator = this.modifications.iterator();
        while (iterator.hasNext()) {
            iterator.next().toString(buffer);
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append("})");
    }
}

