/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.attachment;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.ui.swing.actions.EditAttachmentAction;
import com.franciaflex.faxtomail.ui.swing.actions.OpenAttachmentAction;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentEditorUI;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentEditorUIModel;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentItem;
import com.franciaflex.faxtomail.ui.swing.util.AbstractToolbarPopupHandler;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import com.google.common.collect.Iterables;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;

public class AttachmentEditorUIHandler
extends AbstractToolbarPopupHandler<AttachmentEditorUIModel, AttachmentEditorUI> {
    @Override
    public void afterInit(AttachmentEditorUI ui) {
        ui.getFile().setDialogOwner((JDialog)ui);
        super.afterInit(ui);
        this.initTable(ui.getAttachments());
        ((AttachmentEditorUIModel)((Object)this.getModel())).addPropertyChangeListener("attachment", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractTableModel tableModel = (AbstractTableModel)((AttachmentEditorUI)AttachmentEditorUIHandler.this.getUI()).getAttachments().getModel();
                tableModel.fireTableDataChanged();
            }
        });
    }

    protected void initTable(JXTable table) {
        AbstractTableModel attachmentTableModel = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return CollectionUtils.size(((AttachmentEditorUIModel)((Object)AttachmentEditorUIHandler.this.getModel())).getAttachment());
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return Iterables.get(((AttachmentEditorUIModel)((Object)AttachmentEditorUIHandler.this.getModel())).getAttachment(), (int)rowIndex);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }
        };
        attachmentTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ((AttachmentEditorUI)AttachmentEditorUIHandler.this.getUI()).pack();
            }
        });
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        TableColumn column = new TableColumn();
        column.setCellRenderer(new AttachmentItemRenderer());
        column.setCellEditor(new AttachmentItemEditor());
        columnModel.addColumn(column);
        table.setModel((TableModel)attachmentTableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        table.addHighlighter(HighlighterFactory.createAlternateStriping());
    }

    protected JComponent getComponentToFocus() {
        return ((AttachmentEditorUI)this.getUI()).getFile();
    }

    public void onCloseUI() {
    }

    public SwingValidator<AttachmentEditorUIModel> getValidator() {
        return null;
    }

    public void openAttachment(Attachment attachment) {
        OpenAttachmentAction openAttachmentAction = new OpenAttachmentAction(this);
        openAttachmentAction.setAttachment(attachment, true);
        this.getContext().getActionEngine().runAction((AbstractApplicationAction)openAttachmentAction);
    }

    public void editAttachment(Attachment attachment) {
        OpenAttachmentAction openAttachmentAction = new OpenAttachmentAction(this);
        AttachmentEditorUIModel model = (AttachmentEditorUIModel)((Object)this.getModel());
        if (model.isEditable() && FaxToMailUIUtil.isFileTypeEditable(attachment.getOriginalFileName())) {
            this.getContext().closeSecondaryFrame();
            EditAttachmentAction editAttachmentAction = new EditAttachmentAction(this, attachment);
            this.getContext().getActionEngine().runAction((AbstractApplicationAction)editAttachmentAction);
        } else if (attachment.getEditedFileName() != null) {
            openAttachmentAction.setAttachment(attachment, false);
            this.getContext().getActionEngine().runAction((AbstractApplicationAction)openAttachmentAction);
        }
    }

    public void removeAttachment(AttachmentItem attachmentItem) {
        Attachment attachment = attachmentItem.getAttachment();
        int answer = JOptionPane.showConfirmDialog((Component)this.ui, I18n.t((String)"faxtomail.attachmentEditor.deleteAttachment.message", (Object[])new Object[]{attachment.getOriginalFileName()}), I18n.t((String)"faxtomail.attachmentEditor.deleteAttachment.title", (Object[])new Object[0]), 0);
        if (answer == 0) {
            ((AttachmentEditorUI)this.ui).getAttachments().getCellEditor().stopCellEditing();
            ((AttachmentEditorUIModel)((Object)this.getModel())).removeAttachment(attachment);
            ((AttachmentEditorUI)this.ui).pack();
        }
    }

    public boolean isAttachmentEditable(Attachment attachment) {
        return FaxToMailUIUtil.isFileTypeEditable(attachment.getOriginalFileName()) && (((AttachmentEditorUIModel)((Object)this.getModel())).isEditable() || attachment.getEditedFileName() != null);
    }

    public boolean isAttachmentRemovable(Attachment attachment) {
        return attachment != null && attachment.getTopiaId() == null;
    }

    protected class AttachmentItemEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        protected AttachmentItem attachmentItem = new AttachmentItem();

        public AttachmentItemEditor() {
            this.attachmentItem.setHandler(AttachmentEditorUIHandler.this);
            this.attachmentItem.getOpenAttachmentButton().addActionListener(this);
            this.attachmentItem.getEditAttachmentButton().addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Attachment attachment = (Attachment)value;
            this.attachmentItem.setAttachment(attachment);
            if (attachment != null) {
                JLabel label = this.attachmentItem.getAttachmentNameLabel();
                String actionIconName = attachment.isAddedByUser() ? "user" : "email";
                ImageIcon icon = SwingUtil.createActionIcon((String)actionIconName);
                label.setIcon(icon);
            }
            this.attachmentItem.setEditable(((AttachmentEditorUIModel)((Object)AttachmentEditorUIHandler.this.getModel())).isEditable());
            return this.attachmentItem;
        }

        @Override
        public Object getCellEditorValue() {
            return this.attachmentItem.getAttachment();
        }
    }

    protected class AttachmentItemRenderer
    extends AttachmentItem
    implements TableCellRenderer {
        public AttachmentItemRenderer() {
            this.setHandler(AttachmentEditorUIHandler.this);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Attachment attachment = (Attachment)value;
            this.setAttachment(attachment);
            if (attachment != null) {
                JLabel label = this.getAttachmentNameLabel();
                String actionIconName = attachment.isAddedByUser() ? "user" : "email";
                ImageIcon icon = SwingUtil.createActionIcon((String)actionIconName);
                label.setIcon(icon);
            }
            this.setEditable(((AttachmentEditorUIModel)((Object)AttachmentEditorUIHandler.this.getModel())).isEditable());
            return this;
        }
    }
}

