/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.jpeg;

import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

final class JPEGSegmentImageInputStream
extends ImageInputStreamImpl {
    private final ImageInputStream stream;
    private final List<Segment> segments = new ArrayList<Segment>(64);
    private int currentSegment = -1;
    private Segment segment;

    JPEGSegmentImageInputStream(ImageInputStream imageInputStream) {
        this.stream = (ImageInputStream)Validate.notNull((Object)imageInputStream, (String)"stream");
    }

    private Segment fetchSegment() throws IOException {
        block15: {
            if (this.currentSegment == -1) {
                this.streamInit();
            } else {
                this.segment = this.segments.get(this.currentSegment);
            }
            if (this.streamPos >= this.segment.end()) {
                while (++this.currentSegment < this.segments.size()) {
                    this.segment = this.segments.get(this.currentSegment);
                    if (this.streamPos < this.segment.start || this.streamPos >= this.segment.end()) continue;
                    this.stream.seek(this.segment.realStart + this.streamPos - this.segment.start);
                    return this.segment;
                }
                this.stream.seek(this.segment.realEnd());
                while (true) {
                    long l = this.stream.getStreamPosition();
                    int n = 0;
                    int n2 = this.stream.readUnsignedByte();
                    while (n2 != 255) {
                        n2 = this.stream.readUnsignedByte();
                        ++n;
                        ++l;
                    }
                    if (n != 0) {
                        // empty if block
                    }
                    n2 = 0xFF00 | this.stream.readUnsignedByte();
                    while (n2 == 65535) {
                        ++l;
                        n2 = 0xFF00 | this.stream.readUnsignedByte();
                    }
                    if (JPEGSegmentImageInputStream.isAppSegmentMarker(n2) && (n2 != 65505 || !JPEGSegmentImageInputStream.isAppSegmentWithId("Exif", this.stream)) && n2 != 65518) {
                        int n3 = this.stream.readUnsignedShort();
                        this.stream.seek(l + 2L + (long)n3);
                        continue;
                    }
                    if (n2 == 65497) {
                        this.segment = new Segment(n2, l, this.segment.end(), 2L);
                        this.segments.add(this.segment);
                    } else {
                        long l2 = n2 == 65498 ? Long.MAX_VALUE - l : (long)(this.stream.readUnsignedShort() + 2);
                        this.segment = new Segment(n2, l, this.segment.end(), l2);
                        this.segments.add(this.segment);
                    }
                    this.currentSegment = this.segments.size() - 1;
                    if (this.streamPos >= this.segment.start && this.streamPos < this.segment.end()) {
                        this.stream.seek(this.segment.realStart + this.streamPos - this.segment.start);
                        break block15;
                    }
                    this.stream.seek(this.segment.realEnd());
                }
            }
            if (this.streamPos < this.segment.start) {
                while (--this.currentSegment >= 0) {
                    this.segment = this.segments.get(this.currentSegment);
                    if (this.streamPos < this.segment.start || this.streamPos >= this.segment.end()) continue;
                    this.stream.seek(this.segment.realStart + this.streamPos - this.segment.start);
                    break;
                }
            } else {
                this.stream.seek(this.segment.realStart + this.streamPos - this.segment.start);
            }
        }
        return this.segment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isAppSegmentWithId(String string, ImageInputStream imageInputStream) throws IOException {
        Validate.notNull((Object)string, (String)"segmentId");
        imageInputStream.mark();
        try {
            int n = imageInputStream.readUnsignedShort();
            byte[] byArray = new byte[Math.max(20, n - 2)];
            imageInputStream.readFully(byArray);
            boolean bl = string.equals(JPEGSegmentImageInputStream.asNullTerminatedAsciiString(byArray, 0));
            return bl;
        }
        finally {
            imageInputStream.reset();
        }
    }

    static String asNullTerminatedAsciiString(byte[] byArray, int n) {
        for (int i = 0; i < byArray.length - n; ++i) {
            if (byArray[n + i] != 0 && i <= 255) continue;
            return JPEGSegmentImageInputStream.asAsciiString(byArray, n, n + i);
        }
        return null;
    }

    static String asAsciiString(byte[] byArray, int n, int n2) {
        return new String(byArray, n, n2, Charset.forName("ascii"));
    }

    private void streamInit() throws IOException {
        this.stream.seek(0L);
        int n = this.stream.readUnsignedShort();
        if (n != 65496) {
            throw new IIOException(String.format("Not a JPEG stream (starts with: 0x%04x, expected SOI: 0x%04x)", n, 65496));
        }
        this.segment = new Segment(n, 0L, 0L, 2L);
        this.segments.add(this.segment);
        this.currentSegment = this.segments.size() - 1;
    }

    static boolean isAppSegmentMarker(int n) {
        return n >= 65504 && n <= 65519;
    }

    private void repositionAsNecessary() throws IOException {
        if (this.segment == null || this.streamPos < this.segment.start || this.streamPos >= this.segment.end()) {
            this.fetchSegment();
        }
    }

    public int read() throws IOException {
        this.bitOffset = 0;
        this.repositionAsNecessary();
        int n = this.stream.read();
        if (n != -1) {
            ++this.streamPos;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        this.bitOffset = 0;
        for (n3 = 0; n3 < n2; n3 += n4) {
            this.repositionAsNecessary();
            n4 = this.stream.read(byArray, n + n3, (int)Math.min((long)(n2 - n3), this.segment.end() - this.streamPos));
            if (n4 == -1) {
                if (n3 != 0) break;
                return -1;
            }
            this.streamPos += (long)n4;
        }
        return n3;
    }

    protected void finalize() throws Throwable {
    }

    static class Segment {
        private final int marker;
        final long realStart;
        final long start;
        final long length;

        Segment(int n, long l, long l2, long l3) {
            this.marker = n;
            this.realStart = l;
            this.start = l2;
            this.length = l3;
        }

        long realEnd() {
            return this.realStart + this.length;
        }

        long end() {
            return this.start + this.length;
        }

        public String toString() {
            return String.format("0x%04x[%d-%d]", this.marker, this.realStart, this.realEnd());
        }
    }
}

