/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.actions;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.MainUI;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentEditorUI;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentEditorUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentEditorUIModel;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorUIModel;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import org.nuiton.i18n.I18n;

public class EditAttachmentAction
extends AbstractFaxToMailAction<AttachmentEditorUIModel, AttachmentEditorUI, AttachmentEditorUIHandler> {
    protected Attachment attachment;
    protected PDFEditorUI dialogContent;
    protected JFrame frame;

    public EditAttachmentAction(AttachmentEditorUIHandler handler) {
        super(handler, false);
    }

    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
        String attachmentName = attachment.getEditedFileName() != null ? attachment.getEditedFileName() : attachment.getOriginalFileName();
        this.setActionDescription(I18n.t((String)"faxtomail.action.attachment.edit.tip", (Object[])new Object[]{attachmentName}));
    }

    @Override
    public void doAction() throws Exception {
        ((AttachmentEditorUIModel)this.getModel()).fireAttachmentOpened(this.attachment, false);
        FaxToMailUIUtil.forceAttachmentFileLoading(this.getContext(), this.attachment);
        this.dialogContent = new PDFEditorUI((FaxToMailUI)this.getUI());
        PDFEditorUIModel pdfEditorUIModel = this.dialogContent.getModel();
        pdfEditorUIModel.fromEntity(this.attachment);
        pdfEditorUIModel.setDemand(this.getContext().getCurrentEmail());
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        MainUI mainUI = this.getContext().getMainUI();
        this.frame = ((AttachmentEditorUIHandler)this.getHandler()).openModalFrame(this.dialogContent, this.attachment.getOriginalFileName(), mainUI.getSize());
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
                EditAttachmentAction.this.dialogContent.getModel().toEntity(EditAttachmentAction.this.attachment);
            }
        });
    }

    protected void releaseAction() {
        super.releaseAction();
        if (this.frame != null) {
            this.frame.toFront();
            this.frame = null;
        }
    }
}

