/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.search.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.sf.ehcache.search.Result;
import net.sf.ehcache.search.impl.ResultImpl;
import net.sf.ehcache.store.StoreQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderComparator
implements Comparator<Result> {
    private final List<Comparator<Result>> comparators = new ArrayList<Comparator<Result>>();

    public OrderComparator(List<StoreQuery.Ordering> orderings) {
        int pos = 0;
        for (StoreQuery.Ordering ordering : orderings) {
            switch (ordering.getDirection()) {
                case ASCENDING: {
                    this.comparators.add(new AscendingComparator(pos));
                    break;
                }
                case DESCENDING: {
                    this.comparators.add(new DescendingComparator(pos));
                    break;
                }
                default: {
                    throw new AssertionError((Object)ordering.getDirection());
                }
            }
            ++pos;
        }
    }

    @Override
    public int compare(Result o1, Result o2) {
        for (Comparator<Result> c : this.comparators) {
            int cmp = c.compare(o1, o2);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DescendingComparator
    implements Comparator<Result> {
        private final int pos;

        DescendingComparator(int pos) {
            this.pos = pos;
        }

        @Override
        public int compare(Result o1, Result o2) {
            Object attr1 = ((ResultImpl)o1).getSortAttribute(this.pos);
            Object attr2 = ((ResultImpl)o2).getSortAttribute(this.pos);
            if (attr1 == null && attr2 == null) {
                return 0;
            }
            if (attr1 == null) {
                return 1;
            }
            if (attr2 == null) {
                return -1;
            }
            return ((Comparable)attr2).compareTo(attr1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AscendingComparator
    implements Comparator<Result> {
        private final int pos;

        AscendingComparator(int pos) {
            this.pos = pos;
        }

        @Override
        public int compare(Result o1, Result o2) {
            Object attr1 = ((ResultImpl)o1).getSortAttribute(this.pos);
            Object attr2 = ((ResultImpl)o2).getSortAttribute(this.pos);
            if (attr1 == null && attr2 == null) {
                return 0;
            }
            if (attr1 == null) {
                return -1;
            }
            if (attr2 == null) {
                return 1;
            }
            return ((Comparable)attr1).compareTo(attr2);
        }
    }
}

