package com.franciaflex.faxtomail.ui.swing.content.attachment;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.util.AbstractToolbarPopupUI;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.FileEditor;
import jaxx.runtime.swing.model.JaxxDefaultListModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n.t;

public class AttachmentEditorUI extends AbstractToolbarPopupUI<AttachmentEditorUIModel, AttachmentEditorUIHandler> {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_BUTTON_ENABLED = "addButton.enabled";
    public static final String BINDING_ATTACHMENTS_VISIBLE = "attachments.visible";
    public static final String BINDING_FORM_PANEL_VISIBLE = "formPanel.visible";
    public static final String BINDING_NO_ATTACHMENTS_LABEL_VISIBLE = "noAttachmentsLabel.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Wz28bRRSeuHF+OdCSqCbQgjZtkBIpTEJRDygIGqeNmigBVAcpag4w3h07E2Z3ht23zQYLxJ/AnwB3LkjcOCEOnDlwQfwLCHHgingzu961k3XiQ6NoZe1733vf+/XZ3/9FqlFIFk9YktAwDkD4nO5uHh5+2DrhLjzkkRsKDSok6d9YhVSOSM3L30dA7h7tGfhaBl/bUr5WAQ/60Bt7ZCaCM8mjY84ByGuDCDeK1pq5eSPRcdiLmpMqi/rtP39XvvG+/q5CSKKR3SyW4lyFKioZ3yMV4QGZw0zP2JpkQQdphCLoIN8XzLstyaLoA+bzz8lXZHKPTGgWYjAgd0Yv2caw+EQDucEAmHvsG1/BpOoAeewqn7ZDFriCtSVPaJsloHwmJI0FjU6RD3VVAAihBZpu5h8feQITfryjtc0zAaTqK49LIPvPK/S+iVfEH28p7wzIogo79ASX4TNQOg2X0N3DAwGSex+xoB+yUMRvILjphkpK4wPkZdPqJKOzW1gM8noeYBppBzYoTmwAYV8ar7nceS5QRRHRHmtdRNmXxv1mjqoVHHGvbw2pjrUkH8RNt1XoZ9QWBvYvzVUCmV3abXLcJobtXQdSH2xBz2KcX+9LIyTPab86aBw3RiBLJem5HSLdRod0nufCMs9rxAC4B2R+gEf6NvMOya2B2Hi0tDja4qrGjkg1jPE19uLo4p0/QVN64QvnLtwEtNb/6vO///Tnj9u9s57G3DdLXftUCc9Nh0rzEIRJfT296RiEXNtneuMIo3CJkmYl63YJsWZmRnKY7yUDpwZOH7PoGENUJ//4+Zf6p79dI5VtMiMV87aZ8d8h03AcYheU9BL9/gPLaPZ0Cp83DDfk4rNE+LH/RJ1uqdjIR+XeeoIduF3SgZxGa/rXf+ebPzzodaGCrF4Z6l50ovqUTIhAioBbecuUq1TOajrisacKhSrTLIKqVW9wFuD+AA/NKqPctVRDJdl1bxiXWeNyzvCWfd4v60nNF4HpSVN8gctzp+sE/NSxPWenQB9ieUEkVLB87/76qrO+4nyZxCbWOwadJS0RU3114ioYdQLiFFLIzskdtS5lCa3uXZVkHP2AJzjm1Uty9EkN5b4GlNPJZyISLUPubtexCk47HAodW16hInpkfJexIUBm2niyb9qBAc4cmBQufmip0MMzIBtdp/+aG/Z1urNn1A05A26DpYblt1ed7H9It0s09apWVPqLWuo6iyNUNWXkilnEOIRx6Rz6hXqEmRcc6r3GYsoszfKQcgtRH6HKKWnasa2w7VNdx0ixKSVbgzcuWYO24NKjBlDOoaf4IyzdJA9MPd7QKnFjcPp4VTvmO59cQ93HqX7CtMbFYcawac34k6TrjPDLIQ0W0U3PK8aZhqCuURCTsgZKyQOhD2wrVi67iBSJrPAAdWk78m+qEYY+IdmZQmfy4rseA+a0ROAh6/cuBB4zzzpG/B/KaAk1DQsAAA==";
    private static final Log log = LogFactory.getLog(AttachmentEditorUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addButton;
    protected JScrollPane attachmentBodyScrollPane;
    protected AttachmentEditorUI attachmentDialog = this;
    protected JXTable attachments;
    protected FileEditor file;
    protected JLabel fileLabel;
    protected Table formPanel;
    protected final AttachmentEditorUIHandler handler = new AttachmentEditorUIHandler();
    protected JPanel mainPanel;
    protected AttachmentEditorUIModel model;
    protected JLabel noAttachmentsLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AttachmentEditorUI(FaxToMailUIContext param0) {
        super(param0);
        $initialize();
    }

    public AttachmentEditorUI(Window param0) {
        super(param0);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Window param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Window param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public AttachmentEditorUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Dialog param1, String param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AttachmentEditorUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Window param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Window param1, String param2, ModalityType param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AttachmentEditorUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public AttachmentEditorUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Frame param1, String param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AttachmentEditorUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Frame param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Frame param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Frame param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI() {
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public AttachmentEditorUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Dialog param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Dialog param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Dialog param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddButton() {
        return addButton;
    }

    public JScrollPane getAttachmentBodyScrollPane() {
        return attachmentBodyScrollPane;
    }

    public JXTable getAttachments() {
        return attachments;
    }

    public FileEditor getFile() {
        return file;
    }

    public JLabel getFileLabel() {
        return fileLabel;
    }

    public Table getFormPanel() {
        return formPanel;
    }

    public AttachmentEditorUIHandler getHandler() {
        return handler;
    }

    public JPanel getMainPanel() {
        return mainPanel;
    }

    public AttachmentEditorUIModel getModel() {
        return model;
    }

    public JLabel getNoAttachmentsLabel() {
        return noAttachmentsLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAttachmentBodyScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        attachmentBodyScrollPane.getViewport().add(mainPanel);
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(attachmentBodyScrollPane);
    }

    protected void addChildrenToFormPanel() {
        if (!allComponentsCreated) {
            return;
        }
        formPanel.add($JSeparator0, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        formPanel.add(fileLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        formPanel.add(file, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        formPanel.add(addButton, new GridBagConstraints(2, 1, 1, 3, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToMainPanel() {
        if (!allComponentsCreated) {
            return;
        }
        mainPanel.add(noAttachmentsLabel, BorderLayout.NORTH);
        mainPanel.add(attachments, BorderLayout.CENTER);
        mainPanel.add(formPanel, BorderLayout.SOUTH);
    }

    protected void createAddButton() {
        $objectMap.put("addButton", addButton = new JButton());
        
        addButton.setName("addButton");
        addButton.setToolTipText(t("faxtomail.attachmentEditor.action.add.tip"));
        addButton.putClientProperty("applicationAction",  com.franciaflex.faxtomail.ui.swing.actions.AddAttachmentAction.class );
    }

    protected void createAttachmentBodyScrollPane() {
        $objectMap.put("attachmentBodyScrollPane", attachmentBodyScrollPane = new JScrollPane());
        
        attachmentBodyScrollPane.setName("attachmentBodyScrollPane");
    }

    protected void createAttachments() {
        $objectMap.put("attachments", attachments = new JXTable());
        
        attachments.setName("attachments");
        attachments.setEditable(true);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
        body.setTitle(t("faxtomail.attachmentEditor.title"));
    }

    protected void createFile() {
        $objectMap.put("file", file = new FileEditor());
        
        file.setName("file");
    }

    protected void createFileLabel() {
        $objectMap.put("fileLabel", fileLabel = new JLabel());
        
        fileLabel.setName("fileLabel");
        fileLabel.setText(t("faxtomail.attachmentEditor.field.file"));
    }

    protected void createFormPanel() {
        $objectMap.put("formPanel", formPanel = new Table());
        
        formPanel.setName("formPanel");
    }

    protected void createMainPanel() {
        $objectMap.put("mainPanel", mainPanel = new JPanel());
        
        mainPanel.setName("mainPanel");
        mainPanel.setLayout(new BorderLayout());
    }

    protected void createModel() {
        $objectMap.put("model", model = new AttachmentEditorUIModel());
    }

    protected void createNoAttachmentsLabel() {
        $objectMap.put("noAttachmentsLabel", noAttachmentsLabel = new JLabel());
        
        noAttachmentsLabel.setName("noAttachmentsLabel");
        noAttachmentsLabel.setText(t("faxtomail.attachmentEditor.attachments.empty"));
        if (noAttachmentsLabel.getFont() != null) {
            noAttachmentsLabel.setFont(noAttachmentsLabel.getFont().deriveFont(noAttachmentsLabel.getFont().getStyle() | Font.ITALIC));
        }
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        addChildrenToAttachmentBodyScrollPane();
        addChildrenToMainPanel();
        addChildrenToFormPanel();
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        setMinimumSize( new java.awt.Dimension(250, 0) );
        noAttachmentsLabel.setBorder( javax.swing.BorderFactory.createEmptyBorder(3, 3, 3, 3) );
        fileLabel.setLabelFor( file );
        addButton.setIcon(SwingUtil.createActionIcon("add"));
        // late initializer
        attachmentDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("attachmentDialog", attachmentDialog);
        createModel();
        createAttachmentBodyScrollPane();
        createMainPanel();
        createNoAttachmentsLabel();
        createAttachments();
        createFormPanel();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createFileLabel();
        createFile();
        createAddButton();
        // inline creation of attachmentDialog
        setName("attachmentDialog");
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NO_ATTACHMENTS_LABEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("attachment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getAttachment() != null) {
                    noAttachmentsLabel.setVisible( model.getAttachment().isEmpty() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("attachment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ATTACHMENTS_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("attachment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getAttachment() != null) {
                    attachments.setVisible( !model.getAttachment().isEmpty() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("attachment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FORM_PANEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    formPanel.setVisible( model.isEditable() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    addButton.setEnabled( model.isEditable() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
            }
        });
    }

}