package com.franciaflex.faxtomail.ui.swing.util;

/*
 * #%L
 * FaxToMail :: UI
 * %%
 * Copyright (C) 2014 Franciaflex
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.FaxToMailConfiguration;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.HasLabel;
import com.franciaflex.faxtomail.services.DecoratorService;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.content.MainUI;
import com.franciaflex.faxtomail.ui.swing.content.MainUIHandler;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.editor.bean.BeanUIUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.jaxx.application.ApplicationDataUtil;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.action.ApplicationActionUI;
import org.nuiton.jaxx.application.swing.util.*;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

import javax.swing.*;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.JTextComponent;
import java.awt.*;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.*;

import static org.nuiton.i18n.I18n.t;

/**
 * Contract of any UI handler.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public abstract class AbstractFaxToMailUIHandler<M, UI extends FaxToMailUI<M, ?>>
        extends AbstractApplicationUIHandler<M, UI> implements UIMessageNotifier {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(AbstractFaxToMailUIHandler.class);

    @Override
    public void showInformationMessage(String message) {
        getContext().showInformationMessage(message);
    }

    public FaxToMailUIContext getContext() {
        return (FaxToMailUIContext) super.getContext();
    }

    public FaxToMailConfiguration getConfig() {
        return getContext().getConfig();
    }

    @Override
    public Component getTopestUI() {
        Component result;
        ApplicationActionUI actionUI = getContext().getActionUI();
//        if (actionUI.isVisible()) {
            result = actionUI;
//        } else {
//            result = getContext().getMainUI();
//        }
        return result;
    }

    public void clearValidators() {
        MainUI main = getContext().getMainUI();
        Preconditions.checkNotNull(
                main, "No mainUI registred in application context");
        MainUIHandler handler = main.getHandler();
        handler.clearValidators();
    }

    @Override
    public <O> Decorator<O> getDecorator(Class<O> type, String name) {
        DecoratorService decoratorService =
                getContext().getDecoratorService();

        Preconditions.checkNotNull(type);

        Decorator decorator = decoratorService.getDecoratorByType(type, name);
        Preconditions.checkNotNull(decorator);
        return decorator;
    }

    public String decorate(Serializable s) {
        return super.decorate(s);
    }

    public String decorateUser(FaxToMailUser user, boolean systemIfNull) {
        if (user == null && systemIfNull) {
            return t("faxtomail.systemUser");
        }
        return decorate(user);
    }

    public void setText(ItemEvent e, String property) {
        String value = JAXXUtil.getStringValue(e.getItem());
        ApplicationDataUtil.setProperty(getModel(), property, value);
    }

    @Override
    public void setText(KeyEvent event, String property) {
        JTextComponent field = (JTextComponent) event.getSource();
        if (field.isEditable()) {
            super.setText(event, property);
        }
    }

    //------------------------------------------------------------------------//
    //-- Internal methods                                                   --//
    //------------------------------------------------------------------------//

    protected void registerValidators(SwingValidator... validators) {
        MainUI main = getContext().getMainUI();
        Preconditions.checkNotNull(
                main, "No mainUI registred in application context");
        MainUIHandler handler = main.getHandler();
        handler.clearValidators();
        for (SwingValidator validator : validators) {
            handler.registerValidator(validator);
        }
    }

    protected void listenValidatorValid(SimpleBeanValidator validator,
                                        final AbstractFaxToMailBeanUIModel model) {
        validator.addPropertyChangeListener(SimpleBeanValidator.VALID_PROPERTY, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug("Model [" + model +
                                      "] pass to valid state [" +
                                      evt.getNewValue() + "]");
                }
                model.setValid((Boolean) evt.getNewValue());
            }
        });
    }

    protected void listenValidationTableHasNoFatalError(final SimpleBeanValidator validator,
                                                        final AbstractFaxToMailBeanUIModel model) {
        getContext().getMainUI().getValidatorMessageWidget().addTableModelListener(new TableModelListener() {
            @Override
            public void tableChanged(TableModelEvent e) {
                boolean valid = !validator.hasFatalErrors();
                if (log.isDebugEnabled()) {
                    log.debug("Model [" + model +
                                      "] pass to valid state [" + valid + "]");
                }
                model.setValid(valid);
            }
        });
    }

    protected void listModelIsModify(AbstractFaxToMailBeanUIModel model) {
        model.addPropertyChangeListener(new PropertyChangeListener() {

            final Set<String> excludeProperties = getPropertiesToIgnore();

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object newValue = evt.getNewValue();
                Object oldValue = evt.getOldValue();
                if (!excludeProperties.contains(evt.getPropertyName())
                        //check that the new value and old value are not both null
                        && newValue != oldValue) {
                    ((AbstractFaxToMailBeanUIModel) evt.getSource()).setModify(true);
                }
            }
        });
    }

    protected Set<String> getPropertiesToIgnore() {
        return Sets.newHashSet(
                AbstractFaxToMailBeanUIModel.PROPERTY_MODIFY,
                AbstractFaxToMailBeanUIModel.PROPERTY_VALID);
    }

    public void openFrame(ApplicationUI dialogContent,
                           String title, Dimension dim) {

        JFrame result = getContext().getSecondaryFrame();
        if (result == null) {
            result = new JFrame();
            result.setResizable(true);
            getContext().setSecondaryFrame(result);
        }

        result.setTitle(title);
        result.setContentPane((Container) dialogContent);

        result.setSize(dim);

        final AbstractApplicationUIHandler handler = dialogContent.getHandler();

        if (handler instanceof org.nuiton.jaxx.application.swing.util.Cancelable) {

            // add a auto-close action
            JRootPane rootPane = result.getRootPane();

            KeyStroke shortcutClosePopup = getContext().getConfiguration().getShortcutClosePopup();

            rootPane.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
                    shortcutClosePopup, "close");
            rootPane.getActionMap().put("close", new AbstractAction() {
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((org.nuiton.jaxx.application.swing.util.Cancelable) handler).cancel();
                }
            });
        }

        SwingUtil.center(getContext().getMainUI(), result);
        result.setVisible(true);
    }

    public void closeFrame() {
        getParentContainer(JFrame.class).setVisible(false);
    }

    protected <HL extends HasLabel> void initCheckBoxComboBox(final JComboBox comboBox,
                                                              java.util.List<HL> values,
                                                              java.util.List<HL> selection,
                                                              String property,
                                                              boolean addNull) {

        java.util.List<HL> universe = new ArrayList<HL>();
        if (addNull) {
            universe.add(null);
        }
        if (values != null) {
            universe.addAll(values);
        }
        final ComboBoxModel comboModel = new CheckBoxComboBoxModel(universe, selection);
        comboBox.setModel(comboModel);
        comboBox.setRenderer(new CheckBoxListCellRenderer() {
            @Override
            protected boolean isCheckBoxSelected(Object value) {
                return ((java.util.List<Object>) comboModel.getSelectedItem()).contains(value);
            }
        });
        final Method mutator = BeanUIUtil.getMutator(getModel(), property);
        comboBox.addItemListener(new ItemListener() {
            @Override
            public void itemStateChanged(ItemEvent e) {
                comboBox.showPopup();

                if (e.getStateChange() == ItemEvent.SELECTED) {
                    BeanUIUtil.invokeMethod(mutator,
                                            getModel(),
                                            e.getItem());
                }
            }
        });
    }

}
