package com.franciaflex.faxtomail.ui.swing.content.pdfeditor;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.util.JImagePanel;
import com.itextpdf.text.pdf.BaseFont;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class PDFEditorNoteUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_TEXT = "text";
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_ZOOM = "zoom";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_NOTE_TEXT_FONT_SIZE = "noteText.font-size";
    public static final String BINDING_NOTE_TITLE_FONT_SIZE = "noteTitle.font-size";
    public static final String BINDING_NOTE_TITLE_TEXT = "noteTitle.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Uz28bRRR+dmMnTn8FQqoiirRQIdkI1oJrENRxbMXVkkTEbUJ8KOPdcbLpeGc6O5tsahXxJ/AnwJ0LEjdOiANnDlwQ/wJCHLgi3sxuvN5mkQuWvRq/ee+b73v7vfnmd6iEEt44IXFsyyhQ/pja91sHBzvDE+qqTRq60heKS0g+pTKUB3DVm8ZDBXcHji5vpuXNNh8LHtBgpnrdgeVQnTMaHlOqFLyer3DDsLk33V6PRSQvUKekilC/+vOP8pfeF1+XAWKB7JZQijWvKlOy4EDZ9xS8jCedkiYjwRHSkH5whHyv61ibkTDcJmP6BD6HRQeqgkgEU/Dmi0s2GKY+FgpqAVd0lwSUKdh0+dgeSRK4PhkxGtsjEis+Jj6zI98Oz5CI7fJAIa4tvBH1fMS1dze7HbPaRqQHPSEMeFVBRfmKUQUrmrmt1diJmixlQdFY6fWNmdhTzscKbmZVXcaJyhKWNeUtSjwqsVc6LU7J3TdCdFptmm0E9hMm+WSHDJPkV6bJ1yQd81O6ESmFOmE1l59E8wVLBh1FKFjLJetYS1KSkpHwWs4H6DA7c1hmgdIAKjLCsILbg8um/AS3Ejvefs6OGtDs/n1r9Zfvf/uue+HBRTx7rTB1ZoTQG0JygQ319dE3EwNGymfNj4lYH0AtpAznz8zXnQJie+k2ksPzXjLvTpfbWyQ8RojK4q8//Hjrs5+vQLkLy/g+vS7R+T2oqWOJXeDMi8VH9wyja2dL+FzBXxnf9pC4j48kjwKcjJWJ1eYMTfdpx3F29q1nCqpDLo0TmhNrwywT5HPbxfYr2hkLdZ5s1N9/x0q/DetZjF28U9DFqZRh7ae/Vve+vXfRyRIqe/Vf07NuVg6h6gfMD6iZ53RUC+f3qghp5PFsJIuGFGanVKRz8JZ5Ni51rPRcx5YmVhAxpuXqgqbRoVfvQW6S5uFeSYdVwY2JdUSVmah6Q7+BhRHXV9D6xOriwvaoyz1a3yAhNf+3Os7DTr/XbjVwS/qnJlo3W71+y+m1DUhNg7wb+k9xGuoTq+4HqlHf7HRbD5z+o+7Odv/RXu+wY72tzz7EC6LeaBRryuZ9nqTKVFLpAH3EBXkS4em1iTUiLKSaVXErZ0w3E7uexHYJUqfeLE4RzdxNM4/pIh6k/bQvicgTTHt/d27vDesiif+r8f+xM2fI29x2+7g5rzPTK/UFrF5l5JxH2pQfeEQRa+gHHl6/H17CLenn8lxEHT7Rj8fFCGuI8A8fpXbwowgAAA==";
    private static final Log log = LogFactory.getLog(PDFEditorNoteUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel noteHeader;
    protected PDFEditorNoteUI notePanel = this;
    protected JTextArea noteText;
    protected JLabel noteTitle;
    protected JButton removeButton;
    protected String text;
    protected String title;
    protected Float zoom;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public static final int DEFAULT_FONT_SIZE = 12;
    
    
        protected void textTyped() {
            setText(getNoteText().getText());
    
            JPanel container = getParentContainer(JPanel.class);
            Point location = getLocation();
            Insets insets = container.getInsets();
            Dimension size = getPreferredSize();
            setBounds(location.x + insets.left, location.y + insets.top,
                            size.width, size.height);
        }
    
        protected void removeNote() {
            JPanel container = getParentContainer(JPanel.class);
            container.remove(this);
            container.updateUI();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PDFEditorNoteUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PDFEditorNoteUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PDFEditorNoteUI() {
        $initialize();
    }

    public PDFEditorNoteUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PDFEditorNoteUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PDFEditorNoteUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PDFEditorNoteUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PDFEditorNoteUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__removeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        removeNote();
    }

    public void doKeyTyped__on__noteText(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        textTyped();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getNoteHeader() {
        return noteHeader;
    }

    public JTextArea getNoteText() {
        return noteText;
    }

    public JLabel getNoteTitle() {
        return noteTitle;
    }

    public JButton getRemoveButton() {
        return removeButton;
    }

    public String getText() {
        return text;
    }

    public String getTitle() {
        return title;
    }

    public Float getZoom() {
        return zoom;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setText(String text) {
        String oldValue = this.text;
        this.text = text;
        firePropertyChange(PROPERTY_TEXT, oldValue, text);
    }

    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = title;
        firePropertyChange(PROPERTY_TITLE, oldValue, title);
    }

    public void setZoom(Float zoom) {
        Float oldValue = this.zoom;
        this.zoom = zoom;
        firePropertyChange(PROPERTY_ZOOM, oldValue, zoom);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToNoteHeader() {
        if (!allComponentsCreated) {
            return;
        }
        noteHeader.add(noteTitle, BorderLayout.CENTER);
        noteHeader.add(removeButton, BorderLayout.EAST);
    }

    protected void addChildrenToNotePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(noteHeader, BorderLayout.NORTH);
        add(noteText, BorderLayout.CENTER);
    }

    protected void createNoteHeader() {
        $objectMap.put("noteHeader", noteHeader = new JPanel());
        
        noteHeader.setName("noteHeader");
        noteHeader.setLayout( new BorderLayout() );
    }

    protected void createNoteText() {
        $objectMap.put("noteText", noteText = new JTextArea());
        
        noteText.setName("noteText");
        noteText.setColumns(15);
        noteText.setLineWrap(true);
        noteText.setWrapStyleWord(true);
        noteText.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyTyped", this, "doKeyTyped__on__noteText"));
    }

    protected void createNoteTitle() {
        $objectMap.put("noteTitle", noteTitle = new JLabel());
        
        noteTitle.setName("noteTitle");
    }

    protected void createRemoveButton() {
        $objectMap.put("removeButton", removeButton = new JButton());
        
        removeButton.setName("removeButton");
        removeButton.setText(t("X"));
        removeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeButton"));
    }

    protected void createText() {
        $objectMap.put("text", text = new String());
    }

    protected void createTitle() {
        $objectMap.put("title", title = null);
    }

    protected void createZoom() {
        $objectMap.put("zoom", zoom = 1.0f);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToNotePanel();
        addChildrenToNoteHeader();
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 16 property setters
        setBackground( Color.YELLOW );
        setBorder( BorderFactory.createEmptyBorder(2, 2, 2, 2) );
        noteHeader.setBackground( null );
        noteTitle.setFont( Font.decode(BaseFont.HELVETICA).deriveFont(Font.ITALIC) );
        removeButton.setOpaque( false );
        removeButton.setBackground( null );
        removeButton.setBorder( null );
        removeButton.setBorderPainted( false );
        noteText.setLineWrap( false );
        noteText.setOpaque( false );
        noteText.setFont( Font.decode(BaseFont.HELVETICA) );
        noteText.setBackground( null );
        noteText.setBorder( null );
        noteText.setWrapStyleWord( false );
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("notePanel", notePanel);
        createTitle();
        createText();
        createZoom();
        createNoteHeader();
        createNoteTitle();
        createRemoveButton();
        createNoteText();
        // inline creation of notePanel
        setName("notePanel");
        setLayout(new BorderLayout());
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_NOTE_TITLE_TEXT, true ,"title") {
        
            @Override
            public void processDataBinding() {
                noteTitle.setText(t( getTitle() ));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_NOTE_TITLE_FONT_SIZE, true ,"DEFAULT_FONT_SIZE" ,"zoom") {
        
            @Override
            public void processDataBinding() {
                if (noteTitle.getFont() != null) {
                    noteTitle.setFont(noteTitle.getFont().deriveFont((float)  (int)(DEFAULT_FONT_SIZE * getZoom()) ));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_NOTE_TEXT_FONT_SIZE, true ,"DEFAULT_FONT_SIZE" ,"zoom") {
        
            @Override
            public void processDataBinding() {
                if (noteText.getFont() != null) {
                    noteText.setFont(noteText.getFont().deriveFont((float)  (int)(DEFAULT_FONT_SIZE * getZoom()) ));
                }
            }
        });
    }

}