package com.franciaflex.faxtomail.ui.swing.content.config;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FaxToMailConfigUI extends JPanel implements FaxToMailUI<FaxToMailUIContext, FaxToMailConfigUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TPW8TQRAdH9ghDoSPQOQIg4Lp1xWVEQQZWRg5gHAiRbiA9d3a3mjvdtndIxchED+BnwA9DRIdFaKgpqBB/AWEKGgRs2fH55BDxMXK3tn35s2b5zffoWg0XNqmSUJ0HFkeMnL7xtbW3f428+1NZnzNlZUaxp+CB14PFoLpvbFwuddx8PoEXm/KUMmIRTPoRgfKxu4KZkaMWQsX9iN8Y+rdabmRqFjvsU5F5bG++vnDexm8eO0BJArVeTjK6v9Q2SRHO+DxwMIZ7PSE1gWNhihD82iIek+4u6agxtyhIXsMz2GuAyVFNZJZqB1+5JQjxSfKwqIvowEfbkh1j0ZMWGj6MiQDTSOf04FgCRnQxMqQckFiTswOqiGIsUhOxljSosmGXMcXzfT3ZluptEHJQjGUgWO9cgjWKc1mu+kaJBZ5NJzfZyCuhmSrybwr9KCoY7y2UOkd3OZ9LI33WPlrj44wrf5eXvry/tu71uzyzuU+nckemqq0VExb7lqfHG8utlzU16lq9GDeMIHBTYNZzRHWnZRRHPY77eDEwcktakZIUZz7+uHj8qPPR8BrQVlIGrSoe9+GeTvS6IIUQaKur6WKju8cw/OU04bWPxwxgRteeVrLzJ5szFVqzxK0o5pjx1RTf/7Tr6Xu27U9SwooceWfzzNbig+gxCPBI5YmehLW3AQvKMPiQGahzIspHMipmkTsbHpW8uYvCborY/xvLF4NqKWrfR4FGLNrSewg1XQc9+1iwZ1lZPwD5gIGgX0EAAA=";
    private static final Log log = LogFactory.getLog(FaxToMailConfigUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected FaxToMailConfigUI configTopPanel = this;
    protected final FaxToMailConfigUIHandler handler = new FaxToMailConfigUIHandler();
    protected FaxToMailUIContext model;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FaxToMailConfigUI(FaxToMailUI parentUI) {
        FaxToMailUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public FaxToMailConfigUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FaxToMailConfigUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FaxToMailConfigUI() {
        $initialize();
    }

    public FaxToMailConfigUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FaxToMailConfigUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public FaxToMailConfigUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FaxToMailConfigUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public FaxToMailConfigUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public FaxToMailConfigUIHandler getHandler() {
        return handler;
    }

    public FaxToMailUIContext getModel() {
        return model;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(FaxToMailUIContext.class));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("configTopPanel", configTopPanel);
        createModel();
        // inline creation of configTopPanel
        setName("configTopPanel");
        setLayout(new BorderLayout());
        configTopPanel.putClientProperty("help", "faxtomail.config.help");
        
        $completeSetup();
        handler.afterInit(this);
    }

}