/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.endpoints;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The parameters object used to resolve an endpoint for the S3 service.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public final class S3EndpointParams implements ToCopyableBuilder<S3EndpointParams.Builder, S3EndpointParams> {
    private final String bucket;

    private final Region region;

    private final Boolean useFIPS;

    private final Boolean useDualStack;

    private final String endpoint;

    private final Boolean forcePathStyle;

    private final Boolean accelerate;

    private final Boolean useGlobalEndpoint;

    private final Boolean useObjectLambdaEndpoint;

    private final Boolean disableAccessPoints;

    private final Boolean disableMultiRegionAccessPoints;

    private final Boolean useArnRegion;

    private S3EndpointParams(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.region = builder.region;
        this.useFIPS = builder.useFIPS;
        this.useDualStack = builder.useDualStack;
        this.endpoint = builder.endpoint;
        this.forcePathStyle = builder.forcePathStyle;
        this.accelerate = builder.accelerate;
        this.useGlobalEndpoint = builder.useGlobalEndpoint;
        this.useObjectLambdaEndpoint = builder.useObjectLambdaEndpoint;
        this.disableAccessPoints = builder.disableAccessPoints;
        this.disableMultiRegionAccessPoints = builder.disableMultiRegionAccessPoints;
        this.useArnRegion = builder.useArnRegion;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public String bucket() {
        return bucket;
    }

    public Region region() {
        return region;
    }

    public Boolean useFips() {
        return useFIPS;
    }

    public Boolean useDualStack() {
        return useDualStack;
    }

    public String endpoint() {
        return endpoint;
    }

    public Boolean forcePathStyle() {
        return forcePathStyle;
    }

    public Boolean accelerate() {
        return accelerate;
    }

    public Boolean useGlobalEndpoint() {
        return useGlobalEndpoint;
    }

    public Boolean useObjectLambdaEndpoint() {
        return useObjectLambdaEndpoint;
    }

    public Boolean disableAccessPoints() {
        return disableAccessPoints;
    }

    public Boolean disableMultiRegionAccessPoints() {
        return disableMultiRegionAccessPoints;
    }

    public Boolean useArnRegion() {
        return useArnRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public interface Builder extends CopyableBuilder<Builder, S3EndpointParams> {
        Builder bucket(String bucket);

        Builder region(Region region);

        Builder useFips(Boolean useFIPS);

        Builder useDualStack(Boolean useDualStack);

        Builder endpoint(String endpoint);

        Builder forcePathStyle(Boolean forcePathStyle);

        Builder accelerate(Boolean accelerate);

        Builder useGlobalEndpoint(Boolean useGlobalEndpoint);

        Builder useObjectLambdaEndpoint(Boolean useObjectLambdaEndpoint);

        Builder disableAccessPoints(Boolean disableAccessPoints);

        Builder disableMultiRegionAccessPoints(Boolean disableMultiRegionAccessPoints);

        Builder useArnRegion(Boolean useArnRegion);

        S3EndpointParams build();
    }

    private static class BuilderImpl implements Builder {
        private String bucket;

        private Region region;

        private Boolean useFIPS = false;

        private Boolean useDualStack = false;

        private String endpoint;

        private Boolean forcePathStyle = false;

        private Boolean accelerate = false;

        private Boolean useGlobalEndpoint = false;

        private Boolean useObjectLambdaEndpoint;

        private Boolean disableAccessPoints;

        private Boolean disableMultiRegionAccessPoints = false;

        private Boolean useArnRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(S3EndpointParams builder) {
            this.bucket = builder.bucket;
            this.region = builder.region;
            this.useFIPS = builder.useFIPS;
            this.useDualStack = builder.useDualStack;
            this.endpoint = builder.endpoint;
            this.forcePathStyle = builder.forcePathStyle;
            this.accelerate = builder.accelerate;
            this.useGlobalEndpoint = builder.useGlobalEndpoint;
            this.useObjectLambdaEndpoint = builder.useObjectLambdaEndpoint;
            this.disableAccessPoints = builder.disableAccessPoints;
            this.disableMultiRegionAccessPoints = builder.disableMultiRegionAccessPoints;
            this.useArnRegion = builder.useArnRegion;
        }

        @Override
        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public Builder useFips(Boolean useFIPS) {
            this.useFIPS = useFIPS;
            if (this.useFIPS == null) {
                this.useFIPS = false;
            }
            return this;
        }

        @Override
        public Builder useDualStack(Boolean useDualStack) {
            this.useDualStack = useDualStack;
            if (this.useDualStack == null) {
                this.useDualStack = false;
            }
            return this;
        }

        @Override
        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public Builder forcePathStyle(Boolean forcePathStyle) {
            this.forcePathStyle = forcePathStyle;
            if (this.forcePathStyle == null) {
                this.forcePathStyle = false;
            }
            return this;
        }

        @Override
        public Builder accelerate(Boolean accelerate) {
            this.accelerate = accelerate;
            if (this.accelerate == null) {
                this.accelerate = false;
            }
            return this;
        }

        @Override
        public Builder useGlobalEndpoint(Boolean useGlobalEndpoint) {
            this.useGlobalEndpoint = useGlobalEndpoint;
            if (this.useGlobalEndpoint == null) {
                this.useGlobalEndpoint = false;
            }
            return this;
        }

        @Override
        public Builder useObjectLambdaEndpoint(Boolean useObjectLambdaEndpoint) {
            this.useObjectLambdaEndpoint = useObjectLambdaEndpoint;
            return this;
        }

        @Override
        public Builder disableAccessPoints(Boolean disableAccessPoints) {
            this.disableAccessPoints = disableAccessPoints;
            return this;
        }

        @Override
        public Builder disableMultiRegionAccessPoints(Boolean disableMultiRegionAccessPoints) {
            this.disableMultiRegionAccessPoints = disableMultiRegionAccessPoints;
            if (this.disableMultiRegionAccessPoints == null) {
                this.disableMultiRegionAccessPoints = false;
            }
            return this;
        }

        @Override
        public Builder useArnRegion(Boolean useArnRegion) {
            this.useArnRegion = useArnRegion;
            return this;
        }

        @Override
        public S3EndpointParams build() {
            return new S3EndpointParams(this);
        }
    }
}
