/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.maven;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class GenerateLiveRebelMojo
extends AbstractMojo {
    private static final String FILENAME = "liverebel.xml";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String version;
    private String name;
    private MavenProject project;
    private boolean alwaysGenerate;
    private File workDirectory;
    private boolean omitVersion;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        File file = "ear".equals(this.project.getPackaging()) ? new File(this.workDirectory, FILENAME) : new File(this.project.getBuild().getOutputDirectory(), FILENAME);
        File pomXml = this.project.getFile();
        if (!this.alwaysGenerate && file.exists() && pomXml.exists() && file.lastModified() > pomXml.lastModified()) {
            log.debug((CharSequence)"Skipping generating liverebel.xml");
            return;
        }
        log.info((CharSequence)"Generating liverebel.xml");
        String xmlName = this.name != null ? this.name : this.project.getGroupId() + ":" + this.project.getArtifactId();
        String xmlVersion = this.version != null ? this.version : this.project.getVersion();
        String contents = GenerateLiveRebelMojo.getLiveRebelXml(xmlName, xmlVersion, this.omitVersion);
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Contents of generated liverebel.xml:" + LINE_SEPARATOR + contents));
        }
        try {
            FileUtils.writeStringToFile((File)file, (String)contents);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not write '" + file + "'", (Exception)e);
        }
    }

    private static String getLiveRebelXml(String app, String version, boolean omitVersion) {
        if (app == null) {
            throw new IllegalArgumentException("Application name is required");
        }
        if (version == null) {
            throw new IllegalArgumentException("Application version is required");
        }
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + LINE_SEPARATOR + "<application xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.zeroturnaround.com\" xsi:schemaLocation=\"http://www.zeroturnaround.com/alderaan/rebel-2_0.xsd\">" + LINE_SEPARATOR + "  <name>" + app + "</name>" + LINE_SEPARATOR + (omitVersion ? "" : "  <version>" + version + "</version>" + LINE_SEPARATOR) + "</application>";
    }
}

