/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.callback;

import org.wildfly.common.Assert;
import org.wildfly.security.auth.callback.ExtendedCallback;
import org.wildfly.security.credential.Credential;

public final class CredentialUpdateCallback
implements ExtendedCallback {
    private final Credential credential;

    public CredentialUpdateCallback(Credential credential) {
        Assert.checkNotNullParam((String)"credential", (Object)credential);
        this.credential = credential;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public <C extends Credential> C getCredential(Class<C> credentialClass) {
        Credential credential = this.credential;
        return (C)(credentialClass.isInstance(credential) ? (Credential)credentialClass.cast(credential) : null);
    }

    @Override
    public boolean isOptional() {
        return false;
    }
}

